/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.CountingConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.StringIteratorPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSStringIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSStringIteratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class StringIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new StringIteratorPrototypeBuiltins();

    protected StringIteratorPrototypeBuiltins() {
        super(JSStringIterator.PROTOTYPE_NAME, StringIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return StringIteratorPrototypeBuiltinsFactory.StringIteratorNextNodeGen.create(context, builtin, StringIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum StringIteratorPrototype implements BuiltinEnum<StringIteratorPrototype>
    {
        next(0);

        private final int length;

        private StringIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class StringIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private TruffleString.ReadCharUTF16Node stringReadNode;
        private final CountingConditionProfile isSurrogatePair = CountingConditionProfile.create();

        public StringIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
            this.stringReadNode = TruffleString.ReadCharUTF16Node.create();
        }

        @Specialization
        protected final JSObject doStringIterator(JSStringIteratorObject iterator, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            int length;
            TruffleString string = iterator.getIteratedString();
            if (string == null) {
                return this.createIterResultObjectNode.execute(Undefined.instance, true);
            }
            int index = iterator.getNextIndex();
            if (index >= (length = Strings.length(string))) {
                iterator.setIteratedString(null);
                return this.createIterResultObjectNode.execute(Undefined.instance, true);
            }
            char first = Strings.charAt(this.stringReadNode, string, index);
            TruffleString result = this.isSurrogatePair.profile(Character.isHighSurrogate(first) && index + 1 < length) && Character.isLowSurrogate(Strings.charAt(this.stringReadNode, string, index + 1)) ? Strings.substring(this.getContext(), substringNode, string, index, 2) : Strings.fromCodePoint(fromCodePointNode, first);
            iterator.setNextIndex(index + Strings.length(result));
            return this.createIterResultObjectNode.execute(result, false);
        }

        @Fallback
        protected static JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not a String Iterator");
        }
    }
}

