/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.IndirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.PolyglotBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;

public final class PolyglotBuiltins
extends JSBuiltinsContainer.SwitchEnum<Polyglot> {
    public static final JSBuiltinsContainer BUILTINS = new PolyglotBuiltins();

    protected PolyglotBuiltins() {
        super(JSRealm.POLYGLOT_CLASS_NAME, Polyglot.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Polyglot builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return PolyglotBuiltinsFactory.PolyglotExportNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 1: {
                return PolyglotBuiltinsFactory.PolyglotImportNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return PolyglotBuiltinsFactory.PolyglotEvalNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return PolyglotBuiltinsFactory.PolyglotEvalFileNodeGen.create(context, builtin, PolyglotBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum Polyglot implements BuiltinEnum<Polyglot>
    {
        export(2),
        import_(1),
        eval(2),
        evalFile(2);

        private final int length;

        private Polyglot(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isOptional() {
            return this == evalFile;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotExportNode
    extends JSBuiltinNode {
        @Node.Child
        private ExportValueNode exportValue = ExportValueNode.create();

        PolyglotExportNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doString(TruffleString identifier, Object value, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object polyglotBindings;
            try {
                polyglotBindings = this.getRealm().getEnv().getPolyglotBindings();
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            JSInteropUtil.writeMember(polyglotBindings, identifier, value, interop, this.exportValue, true, this);
            return value;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isString(identifier)"})
        protected Object doMaybeUnbox(TruffleObject identifier, Object value, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            if (interop.isString(identifier)) {
                TruffleString unboxed = Strings.interopAsTruffleString(identifier, interop, switchEncoding);
                return this.doString(unboxed, value, interop);
            }
            return this.doInvalid(identifier, value);
        }

        @Specialization(guards={"!isString(identifier)"})
        @CompilerDirectives.TruffleBoundary
        protected Object doInvalid(Object identifier, Object value) {
            throw Errors.createTypeErrorInvalidIdentifier(identifier);
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotImportNode
    extends JSBuiltinNode {
        PolyglotImportNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doString(TruffleString identifier, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Shared @Cached ImportValueNode importValueNode, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            Object polyglotBindings;
            try {
                polyglotBindings = this.getRealm().getEnv().getPolyglotBindings();
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            try {
                return importValueNode.executeWithTarget(interop.readMember(polyglotBindings, Strings.toJavaString(toJavaStringNode, identifier)));
            }
            catch (UnknownIdentifierException e) {
                return Undefined.instance;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(polyglotBindings, e, "readMember", identifier, this);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isString(identifier)"})
        protected Object doMaybeUnbox(TruffleObject identifier, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Shared @Cached ImportValueNode importValueNode, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            if (interop.isString(identifier)) {
                TruffleString unboxed = Strings.interopAsTruffleString(identifier, interop, switchEncoding);
                return this.doString(unboxed, interop, importValueNode, toJavaStringNode);
            }
            return this.doInvalid(identifier);
        }

        @Specialization(guards={"!isString(identifier)", "!isTruffleObject(identifier)"})
        @CompilerDirectives.TruffleBoundary
        protected Object doInvalid(Object identifier) {
            throw Errors.createTypeErrorInvalidIdentifier(identifier);
        }
    }

    static abstract class PolyglotEvalNode
    extends PolyglotEvalBaseNode {
        PolyglotEvalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"equals(strEq, language, cachedLanguage)"}, limit="1")
        @CompilerDirectives.TruffleBoundary
        protected Object evalCachedLanguage(TruffleString language, TruffleString source, @Cached(value="language") TruffleString cachedLanguage, @Cached TruffleString.EqualNode strEq, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode, @Cached(value="getLanguageIdAndMimeType(toJavaStringNode, language)") Pair<String, String> languagePair, @Cached @Cached.Shared IndirectCallNode callNode, @Cached @Cached.Shared ImportValueNode importValueNode) {
            return importValueNode.executeWithTarget(callNode.call(this.evalStringIntl(source, languagePair.getFirst(), languagePair.getSecond()), new Object[0]));
        }

        @Specialization(replaces={"evalCachedLanguage"})
        @CompilerDirectives.TruffleBoundary
        protected Object evalString(TruffleString language, TruffleString source, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode, @Cached @Cached.Shared IndirectCallNode callNode, @Cached @Cached.Shared ImportValueNode importValueNode) {
            Pair<String, String> pair = this.getLanguageIdAndMimeType(toJavaStringNode, language);
            return importValueNode.executeWithTarget(callNode.call(this.evalStringIntl(source, pair.getFirst(), pair.getSecond()), new Object[0]));
        }

        private CallTarget evalStringIntl(TruffleString sourceText, String languageId, String mimeType) {
            CompilerAsserts.neverPartOfCompilation();
            this.getContext().checkEvalAllowed();
            Source source = Source.newBuilder(languageId, Strings.toJavaString(sourceText), "<eval>").mimeType(mimeType).build();
            TruffleLanguage.Env env = this.getRealm().getEnv();
            try {
                return env.parsePublic(source, new String[0]);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                throw Errors.createErrorFromException(ex);
            }
        }

        @Specialization(guards={"!isString(languageId) || !isString(source)"})
        protected Object eval(Object languageId, Object source) {
            throw Errors.createTypeError("Expected arguments: (String languageId, String sourceCode)");
        }
    }

    static abstract class PolyglotEvalFileNode
    extends PolyglotEvalBaseNode {
        PolyglotEvalFileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"equals(strEq, language, cachedLanguage)"}, limit="1")
        @CompilerDirectives.TruffleBoundary
        protected Object evalFileCachedLanguage(TruffleString language, TruffleString file, @Cached(value="language") TruffleString cachedLanguage, @Cached TruffleString.EqualNode strEq, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode, @Cached(value="getLanguageIdAndMimeType(toJavaStringNode, language)") Pair<String, String> languagePair, @Cached @Cached.Shared IndirectCallNode callNode, @Cached @Cached.Shared ImportValueNode importValueNode) {
            return importValueNode.executeWithTarget(callNode.call(this.evalFileIntl(file, languagePair.getFirst(), languagePair.getSecond()), new Object[0]));
        }

        @Specialization(replaces={"evalFileCachedLanguage"})
        @CompilerDirectives.TruffleBoundary
        protected Object evalFileString(TruffleString language, TruffleString file, @Cached @Cached.Shared TruffleString.ToJavaStringNode toJavaStringNode, @Cached @Cached.Shared IndirectCallNode callNode, @Cached @Cached.Shared ImportValueNode importValueNode) {
            Pair<String, String> pair = this.getLanguageIdAndMimeType(toJavaStringNode, language);
            return importValueNode.executeWithTarget(callNode.call(this.evalFileIntl(file, pair.getFirst(), pair.getSecond()), new Object[0]));
        }

        private CallTarget evalFileIntl(TruffleString fileName, String languageId, String mimeType) {
            Source source;
            CompilerAsserts.neverPartOfCompilation();
            TruffleLanguage.Env env = this.getRealm().getEnv();
            try {
                source = Source.newBuilder(languageId, env.getPublicTruffleFile(Strings.toJavaString(fileName))).mimeType(mimeType).build();
            }
            catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                String reason = e instanceof AccessDeniedException ? "access denied" : (e instanceof NoSuchFileException ? "no such file" : e.getMessage());
                throw Errors.createError("Cannot evaluate file " + String.valueOf(fileName) + ": " + reason, e);
            }
            try {
                return env.parsePublic(source, new String[0]);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                throw Errors.createErrorFromException(ex);
            }
        }

        @Specialization(guards={"!isString(languageId) || !isString(fileName)"})
        protected Object eval(Object languageId, Object fileName) {
            throw Errors.createTypeError("Expected arguments: (String languageId, String fileName)");
        }
    }

    @ImportStatic(value={Strings.class})
    static abstract class PolyglotEvalBaseNode
    extends JSBuiltinNode {
        PolyglotEvalBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @NeverDefault
        protected Pair<String, String> getLanguageIdAndMimeType(TruffleString.ToJavaStringNode toJavaStringNode, TruffleString languageIdOrMimeTypeTS) {
            String language;
            String languageIdOrMimeType;
            String languageId = languageIdOrMimeType = Strings.toJavaString(toJavaStringNode, languageIdOrMimeTypeTS);
            String mimeType = null;
            if (languageIdOrMimeType.indexOf(47) >= 0 && (language = Source.findLanguage(languageIdOrMimeType)) != null) {
                languageId = language;
                mimeType = languageIdOrMimeType;
            }
            return new Pair<String, Object>(languageId, mimeType);
        }
    }
}

