/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleSafepoint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.StopIterationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownKeyException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.MapPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSMapIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSMapObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

public final class MapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<MapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new MapPrototypeBuiltins();
    static final TruffleObject DEFAULT_VALUE = new TruffleObject(){};

    protected MapPrototypeBuiltins() {
        super(JSMap.PROTOTYPE_NAME, MapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, MapPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return MapPrototypeBuiltinsFactory.JSMapClearNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return MapPrototypeBuiltinsFactory.JSMapDeleteNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return MapPrototypeBuiltinsFactory.JSMapSetNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return MapPrototypeBuiltinsFactory.JSMapGetNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return MapPrototypeBuiltinsFactory.JSMapHasNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return MapPrototypeBuiltinsFactory.JSMapForEachNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 6: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 1, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 2, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 8: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 3, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 9: {
                return MapPrototypeBuiltinsFactory.MapGetSizeNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 10: {
                return MapPrototypeBuiltinsFactory.MapGetOrInsertNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: {
                return MapPrototypeBuiltinsFactory.MapGetOrInsertComputedNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum MapPrototype implements BuiltinEnum<MapPrototype>
    {
        clear(0),
        delete(1),
        set(2),
        get(1),
        has(1),
        forEach(1),
        keys(0),
        values(0),
        entries(0),
        size(0),
        getOrInsert(2),
        getOrInsertComputed(2);

        private final int length;

        private MapPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == size;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 10, 11 -> 17;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class JSMapClearNode
    extends JSBuiltinNode {
        public JSMapClearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static JSDynamicObject doMap(JSMapObject thisObj) {
            JSMap.getInternalMap(thisObj).clear();
            return Undefined.instance;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected JSDynamicObject doForeignMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary iteratorLib, @Cached InlinedBranchProfile growProfile) {
            try {
                Object hashEntriesIterator = mapLib.getHashKeysIterator(thisObj);
                SimpleArrayList<Object> keys = SimpleArrayList.create(mapLib.getHashSize(thisObj));
                while (true) {
                    try {
                        Object nextKey = iteratorLib.getIteratorNextElement(hashEntriesIterator);
                        keys.add(nextKey, this, growProfile);
                    }
                    catch (StopIterationException e) {
                        break;
                    }
                    TruffleSafepoint.poll(this);
                }
                for (Object key : keys.toArray()) {
                    try {
                        mapLib.removeHashEntry(thisObj, key);
                    }
                    catch (UnknownKeyException e) {
                        continue;
                    }
                    TruffleSafepoint.poll(this);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "clear", this);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSDynamicObject notMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapDeleteNode
    extends JSMapOperation {
        public JSMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).remove(normalizedKey);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected boolean doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            Object normalizedKey = this.normalize(key);
            try {
                mapLib.removeHashEntry(thisObj, normalizedKey);
                return true;
            }
            catch (UnknownKeyException e) {
                return false;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "removeHashEntry", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static boolean notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapSetNode
    extends JSMapOperation {
        public JSMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject doMap(JSMapObject thisObj, Object key, Object value) {
            Object normalizedKey = this.normalize(key);
            JSMap.getInternalMap(thisObj).put(normalizedKey, value);
            return thisObj;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, Object value, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached ExportValueNode exportValueNode) {
            Object normalizedKey = this.normalize(key);
            Object exportedValue = exportValueNode.execute(value);
            try {
                mapLib.writeHashEntry(thisObj, normalizedKey, exportedValue);
            }
            catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "writeHashEntry", this);
            }
            return thisObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSDynamicObject notMap(Object thisObj, Object key, Object value, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapGetNode
    extends JSMapOperation {
        public JSMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            Object value = JSMap.getInternalMap(thisObj).get(normalizedKey);
            return JSRuntime.nullToUndefined(value);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached ImportValueNode importValue) {
            Object normalizedKey = this.normalize(key);
            try {
                return importValue.executeWithTarget(mapLib.readHashValueOrDefault(thisObj, normalizedKey, Undefined.instance));
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "readHashValue", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSMapHasNode
    extends JSMapOperation {
        public JSMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean doMap(JSMapObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).has(normalizedKey);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            Object normalizedKey = this.normalize(key);
            return mapLib.isHashEntryReadable(thisObj, normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static boolean notMap(Object thisObj, Object key, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class JSMapForEachNode
    extends JSBuiltinNode {
        public JSMapForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isCallable.executeBoolean(callback)"})
        protected Object doMap(JSMapObject thisObj, Object callback, Object thisArg, @Cached @Cached.Shared IsCallableNode isCallable, @Cached(value="createCall()") @Cached.Shared JSFunctionCallNode callNode) {
            JSHashMap map = JSMap.getInternalMap(thisObj);
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object value = cursor.getValue();
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, callback, value, key, thisObj));
            }
            return Undefined.instance;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)", "isCallable.executeBoolean(callback)"})
        protected Object doForeignMap(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared IsCallableNode isCallable, @Cached(value="createCall()") @Cached.Shared JSFunctionCallNode callNode, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary iteratorLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Exclusive InteropLibrary entryLib, @Cached ImportValueNode importValue) {
            try {
                Object hashEntriesIterator = mapLib.getHashEntriesIterator(thisObj);
                while (true) {
                    Object nextEntry;
                    try {
                        nextEntry = iteratorLib.getIteratorNextElement(hashEntriesIterator);
                    }
                    catch (StopIterationException e) {
                        break;
                    }
                    Object key = importValue.executeWithTarget(entryLib.readArrayElement(nextEntry, 0L));
                    Object value = importValue.executeWithTarget(entryLib.readArrayElement(nextEntry, 1L));
                    callNode.executeCall(JSArguments.create(thisArg, callback, value, key, thisObj));
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "forEach", this);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSMap(thisObj) || isForeignHash(thisObj, mapLib)", "!isCallable.executeBoolean(callback)"})
        protected static Object invalidCallback(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared IsCallableNode isCallable, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object callback, Object thisArg, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSRuntime.class, JSMapOperation.class})
    public static abstract class CreateMapIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        public CreateMapIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
        }

        @Specialization
        protected final JSObject doMap(JSMapObject map) {
            return JSMapIterator.create(this.getContext(), this.getRealm(), map, JSMap.getInternalMap(map).getEntries(), this.iterationKind);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(map)", "isForeignHash(map, mapLib)"})
        protected final JSObject doForeignMap(Object map, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached(value="createSetHidden(ENUMERATE_ITERATOR_ID, getContext())") PropertySetNode setEnumerateIteratorNode) {
            Object iterator;
            try {
                if (this.iterationKind == 1) {
                    iterator = mapLib.getHashKeysIterator(map);
                } else if (this.iterationKind == 2) {
                    iterator = mapLib.getHashValuesIterator(map);
                } else {
                    assert (this.iterationKind == 3);
                    iterator = mapLib.getHashEntriesIterator(map);
                }
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(map, e, "get hash iterator", this);
            }
            JSObject iteratorObj = JSOrdinary.create(this.getContext(), this.getContext().getEnumerateIteratorFactory(), this.getRealm());
            setEnumerateIteratorNode.setValue(iteratorObj, iterator);
            return iteratorObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static JSObject doIncompatibleReceiver(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class, JSMapOperation.class})
    public static abstract class MapGetSizeNode
    extends JSBuiltinNode {
        public MapGetSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static int doMap(JSMapObject thisObj) {
            return JSMap.getMapSize(thisObj);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isJSMap(thisObj)", "isForeignHash(thisObj, mapLib)"})
        protected final Object doForeignMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached(inline=true) LongToIntOrDoubleNode sizeToJSNumber) {
            try {
                long hashSize = mapLib.getHashSize(thisObj);
                return sizeToJSNumber.execute(this, hashSize);
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "getHashSize", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static int notMap(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class MapGetOrInsertNode
    extends JSMapOperation {
        public MapGetOrInsertNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doMap(JSMapObject thisObj, Object key, Object value) {
            Object normalizedKey = this.normalize(key);
            Object result = JSMap.getInternalMap(thisObj).getOrInsert(normalizedKey, value);
            return JSRuntime.nullToUndefined(result);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, Object value, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached ImportValueNode importValue, @Cached ExportValueNode exportValueNode) {
            Object normalizedKey = this.normalize(key);
            try {
                Object result = mapLib.readHashValueOrDefault(thisObj, normalizedKey, DEFAULT_VALUE);
                if (result == DEFAULT_VALUE) {
                    result = exportValueNode.execute(value);
                    mapLib.writeHashEntry(thisObj, normalizedKey, result);
                }
                return importValue.executeWithTarget(result);
            }
            catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException ex) {
                throw Errors.createTypeErrorInteropException(thisObj, ex, "getOrInsert", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object key, Object value, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class MapGetOrInsertComputedNode
    extends JSMapOperation {
        public MapGetOrInsertComputedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doMap(JSMapObject thisObj, Object key, Object callbackfn, @Cached.Shared @Cached IsCallableNode isCallable, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
            if (!isCallable.executeBoolean(callbackfn)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorCallableExpected();
            }
            Object normalizedKey = this.normalize(key);
            JSHashMap internalMap = JSMap.getInternalMap(thisObj);
            Object value = internalMap.get(normalizedKey);
            if (value == null) {
                value = callNode.executeCall(JSArguments.createOneArg(Undefined.instance, callbackfn, normalizedKey));
                internalMap.put(normalizedKey, value);
            }
            return JSRuntime.nullToUndefined(value);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignHash(thisObj, mapLib)"})
        protected Object doForeignMap(Object thisObj, Object key, Object callbackfn, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib, @Cached ImportValueNode importValue, @Cached ExportValueNode exportValueNode, @Cached.Shared @Cached IsCallableNode isCallable, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
            if (!isCallable.executeBoolean(callbackfn)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorCallableExpected();
            }
            Object normalizedKey = this.normalize(key);
            try {
                Object result = mapLib.readHashValueOrDefault(thisObj, normalizedKey, DEFAULT_VALUE);
                if (result == DEFAULT_VALUE) {
                    Object value = callNode.executeCall(JSArguments.createOneArg(Undefined.instance, callbackfn, normalizedKey));
                    result = exportValueNode.execute(value);
                    mapLib.writeHashEntry(thisObj, normalizedKey, result);
                }
                return importValue.executeWithTarget(result);
            }
            catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException ex) {
                throw Errors.createTypeErrorInteropException(thisObj, ex, "getOrInsertComputed", this);
            }
        }

        @Specialization(guards={"!isJSMap(thisObj)", "!isForeignHash(thisObj, mapLib)"})
        protected static Object notMap(Object thisObj, Object key, Object callbackfn, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary mapLib) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode = JSCollectionsNormalizeNode.create();

        protected JSMapOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final Object normalize(Object value) {
            return this.normalizeNode.execute(value);
        }

        protected static boolean isForeignHash(Object value, InteropLibrary interopLibrary) {
            return interopLibrary.hasHashEntries(value) && !(value instanceof JSDynamicObject);
        }
    }
}

