/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAdapterFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostEngineException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodScope;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostToTypeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostToTypeNodeGen;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.HostAccess;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public class HostLanguageService
extends AbstractPolyglotImpl.AbstractHostLanguageService {
    final HostLanguage language;
    private final AbstractPolyglotImpl.APIAccess api;

    HostLanguageService(AbstractPolyglotImpl polyglot, HostLanguage language) {
        super(polyglot);
        this.api = polyglot.getAPIAccess();
        this.language = language;
    }

    @Override
    public void release() {
    }

    @Override
    public void initializeHostContext(Object internalContext, Object receiver, Object hostAccess, ClassLoader cl, Predicate<String> clFilter, boolean hostCLAllowed, boolean hostLookupAllowed) {
        HostContext context = (HostContext)receiver;
        ClassLoader useCl = cl;
        if (useCl == null) {
            useCl = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
        }
        this.language.initializeHostAccess(hostAccess);
        context.initialize(internalContext, useCl, clFilter, hostCLAllowed, hostLookupAllowed, hostAccess != null ? this.api.getMutableTargetMappings(hostAccess) : new HostAccess.MutableTargetMapping[]{});
    }

    @Override
    public void addToHostClassPath(Object receiver, Object truffleFile) {
        HostContext context = (HostContext)receiver;
        context.addToHostClasspath((TruffleFile)truffleFile);
    }

    @Override
    public Object findDynamicClass(Object receiver, String classValue) {
        HostContext context = (HostContext)receiver;
        Class<?> found = context.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forClass(found, context);
    }

    @Override
    public void throwHostLanguageException(String message) {
        throw new HostLanguage.HostLanguageException(message);
    }

    @Override
    public Object findStaticClass(Object receiver, String classValue) {
        HostContext context = (HostContext)receiver;
        Class<?> found = context.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forStaticClass(found, context);
    }

    @Override
    public <T> T toHostType(Object hostNode, Object targetNode, Object hostContext, Object value, Class<T> targetType, Type genericType) {
        HostContext context = (HostContext)hostContext;
        HostToTypeNode node = (HostToTypeNode)hostNode;
        if (node == null) {
            node = HostToTypeNodeGen.getUncached();
        }
        return (T)node.execute((Node)targetNode, context, value, targetType, genericType, true);
    }

    @Override
    public Object asHostStaticClass(Object context, Class<?> value) {
        return HostObject.forStaticClass(value, (HostContext)context);
    }

    @Override
    public Object toGuestValue(Object hostContext, Object hostValue, boolean asValue) {
        HostContext context = (HostContext)hostContext;
        assert (this.validHostValue(hostValue, context)) : "polyglot unboxing should be a no-op at this point.";
        if (HostContext.isGuestPrimitive(hostValue)) {
            return hostValue;
        }
        if (this.api.isProxy(hostValue)) {
            return HostProxy.toProxyGuestObject(context, hostValue);
        }
        if (!asValue && hostValue instanceof HostMethodScope.ScopedObject) {
            return ((HostMethodScope.ScopedObject)hostValue).unwrapForGuest();
        }
        if (hostValue instanceof TruffleObject) {
            return hostValue;
        }
        if (hostValue instanceof Class) {
            return HostObject.forClass((Class)hostValue, context);
        }
        if (hostValue == null) {
            return HostObject.NULL;
        }
        return HostObject.forObject(hostValue, context);
    }

    private boolean validHostValue(Object hostValue, HostContext context) {
        Object unboxed = this.language.access.toGuestValue(context.internalContext, hostValue);
        return unboxed == hostValue;
    }

    @Override
    public boolean isHostValue(Object value) {
        Object obj = HostLanguage.unwrapIfScoped(this.language, value);
        return obj instanceof HostObject || obj instanceof HostFunction || obj instanceof HostException || obj instanceof HostProxy;
    }

    @Override
    public Object unboxHostObject(Object hostValue) {
        return HostObject.valueOf(this.language, hostValue);
    }

    @Override
    public Object unboxProxyObject(Object hostValue) {
        return HostProxy.toProxyHostObject(this.language, hostValue);
    }

    @Override
    public Throwable unboxHostException(Throwable hostValue) {
        if (hostValue instanceof HostException) {
            return ((HostException)hostValue).getOriginal();
        }
        return null;
    }

    @Override
    public Object toHostObject(Object hostContext, Object value) {
        HostContext context = (HostContext)hostContext;
        return HostObject.forObject(value, context);
    }

    @Override
    public Object asHostDynamicClass(Object context, Class<?> value) {
        return null;
    }

    @Override
    public boolean isHostException(Object exception) {
        return exception instanceof HostException;
    }

    @Override
    public boolean isHostFunction(Object value) {
        return HostFunction.isInstance(this.language, value);
    }

    @Override
    public boolean isHostObject(Object value) {
        return HostObject.isInstance(this.language, value);
    }

    @Override
    public boolean isHostProxy(Object value) {
        return HostProxy.isProxyGuestObject(this.language, value);
    }

    @Override
    public boolean isHostSymbol(Object obj) {
        Object o = HostLanguage.unwrapIfScoped(this.language, obj);
        if (o instanceof HostObject) {
            return ((HostObject)o).isStaticClass();
        }
        return false;
    }

    @Override
    public Object createHostAdapter(Object context, Object[] hostTypes, Object classOverrides) {
        CompilerAsserts.neverPartOfCompilation();
        HostContext hostContext = (HostContext)context;
        Class[] javaTypes = new Class[hostTypes.length];
        for (int i = 0; i < hostTypes.length; ++i) {
            HostObject hostType;
            Object type = hostTypes[i];
            if (!(type instanceof HostObject) || !(hostType = (HostObject)type).isDefaultClass()) {
                throw HostEngineException.illegalArgument(hostContext.getHostClassCache().polyglotHostAccess, "Types must be host symbols or host classes.");
            }
            javaTypes[i] = hostType.asClass();
        }
        HostAdapterFactory.AdapterResult adapter = HostAdapterFactory.getAdapterClassFor(hostContext, javaTypes, classOverrides);
        if (!adapter.isSuccess()) {
            throw adapter.throwException();
        }
        return HostObject.forStaticClass(adapter.getAdapterClass(), hostContext);
    }

    @Override
    public RuntimeException toHostException(Object context, Throwable exception) {
        HostContext hostContext = (HostContext)context;
        return HostException.wrap(exception, hostContext);
    }

    @Override
    public Object migrateValue(Object targetContext, Object value, Object valueContext) {
        assert (targetContext != valueContext);
        if (value instanceof TruffleObject) {
            assert (value instanceof TruffleObject);
            if (HostObject.isInstance(this.language, value)) {
                return HostObject.withContext(this.language, value, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (value instanceof HostProxy) {
                return HostProxy.withContext(value, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (valueContext == null) {
                assert (value instanceof TruffleObject);
                return value;
            }
            return null;
        }
        assert (InteropLibrary.isValidValue(value));
        return value;
    }

    @Override
    public Error toHostResourceError(Throwable hostException) {
        Throwable t = this.unboxHostException(hostException);
        if (t instanceof StackOverflowError || t instanceof OutOfMemoryError) {
            return (Error)t;
        }
        return null;
    }

    @Override
    public int findNextGuestToHostStackTraceElement(StackTraceElement firstElement, StackTraceElement[] hostStack, int nextElementIndex) {
        StackTraceElement element = firstElement;
        int index = nextElementIndex;
        while (HostLanguageService.isGuestToHostReflectiveCall(element) && index < hostStack.length) {
            element = hostStack[index++];
        }
        if (HostLanguageService.isGuestToHostCallFromHostInterop(element)) {
            return index - nextElementIndex;
        }
        return -1;
    }

    @Override
    public void pin(Object receiver) {
        HostMethodScope.pin(receiver);
    }

    @Override
    public void hostExit(int exitCode) {
        System.exit(exitCode);
    }

    @Override
    public boolean allowsPublicAccess() {
        return this.api.allowsPublicAccess(this.language.hostClassCache.hostAccess);
    }

    private static boolean isGuestToHostCallFromHostInterop(StackTraceElement element) {
        assert (HostLanguageService.assertClassNameUnchanged(HostObject.GuestToHostCalls.class, "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject$GuestToHostCalls"));
        assert (HostLanguageService.assertClassNameUnchanged(GuestToHostCodeCache.class, "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache"));
        assert (HostLanguageService.assertClassNameUnchanged(HostMethodDesc.SingleMethod.class, "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc$SingleMethod"));
        assert (HostLanguageService.assertClassNameUnchanged(GuestToHostCodeCache.GuestToHostInvokeReflect.class, "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache$GuestToHostInvokeReflect"));
        assert (HostLanguageService.assertClassNameUnchanged(GuestToHostCodeCache.GuestToHostInvokeHandle.class, "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache$GuestToHostInvokeHandle"));
        switch (element.getClassName()) {
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc$SingleMethod$MHBase": {
                return element.getMethodName().equals("invokeHandle");
            }
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc$SingleMethod$MethodReflectImpl": {
                return element.getMethodName().equals("reflectInvoke");
            }
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject$GuestToHostCalls": {
                return true;
            }
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache$GuestToHostInvokeReflect": 
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache$GuestToHostInvokeHandle": {
                return element.getMethodName().equals("executeImpl");
            }
            case "org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Engine$APIAccessImpl": {
                return element.getMethodName().startsWith("callProxy");
            }
        }
        return false;
    }

    private static boolean assertClassNameUnchanged(Class<?> c, String name) {
        if (c.getName().equals(name)) {
            return true;
        }
        throw new AssertionError((Object)("Class name is outdated. Expected " + name + " but got " + c.getName()));
    }

    private static boolean isGuestToHostReflectiveCall(StackTraceElement element) {
        switch (element.getClassName()) {
            case "sun.reflect.NativeMethodAccessorImpl": 
            case "sun.reflect.DelegatingMethodAccessorImpl": 
            case "jdk.internal.reflect.NativeMethodAccessorImpl": 
            case "jdk.internal.reflect.DelegatingMethodAccessorImpl": 
            case "java.lang.reflect.Method": {
                return element.getMethodName().startsWith("invoke");
            }
        }
        return false;
    }
}

