/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler;

import java.lang.ref.WeakReference;
import java.util.Objects;
import jdk.vm.ci.code.InstalledCode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilable;

public final class TruffleCompilerAssumptionDependency
implements OptimizedAssumptionDependency {
    private final InstalledCode installedCode;
    private final WeakReference<TruffleCompilable> compilableRef;

    public TruffleCompilerAssumptionDependency(TruffleCompilable compilation, InstalledCode code) {
        Objects.requireNonNull(code);
        this.installedCode = code;
        this.compilableRef = new WeakReference<TruffleCompilable>(compilation);
    }

    @Override
    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        boolean wasActive = false;
        InstalledCode code = this.getInstalledCode();
        if (code != null && code.isAlive()) {
            code.invalidate();
            wasActive = true;
        } else assert (!this.isAlive()) : "Cannot be valid but not alive";
        TruffleCompilable ast = (TruffleCompilable)this.compilableRef.get();
        if (ast != null) {
            ast.onInvalidate(source, reason, wasActive);
        }
    }

    public InstalledCode getInstalledCode() {
        return this.installedCode;
    }

    @Override
    public TruffleCompilable getCompilable() {
        return (TruffleCompilable)this.compilableRef.get();
    }

    @Override
    public boolean isAlive() {
        InstalledCode code = this.getInstalledCode();
        if (code == null) {
            return false;
        }
        return code.isAlive();
    }

    public String toString() {
        return "TruffleCompilerAssumptionDependency[" + this.getInstalledCode().toString() + "]";
    }
}

