/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;

final class InternalErrors {
    InternalErrors() {
    }

    static RuntimeException regionOutOfBounds(int arrayLength, int offset, int length) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IndexOutOfBoundsException(String.format("array (length: %d) region (offset: %d, length: %d) is out of bounds!", arrayLength, offset, length));
    }

    static RuntimeException indexOutOfBounds(int arrayLength, int index) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IndexOutOfBoundsException(String.format("array (length: %d) index (%d) is out of bounds!", arrayLength, index));
    }

    static RuntimeException indexRegionOutOfBounds(int arrayLength, int fromIndex, int toIndex) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IndexOutOfBoundsException(String.format("array (length: %d) region (fromIndex: %d, toIndex: %d) is out of bounds!", arrayLength, fromIndex, toIndex));
    }

    static RuntimeException invalidCodePoint(int c) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IllegalArgumentException(String.format("invalid code point: 0x%x", c));
    }

    static RuntimeException unsupportedOperation() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new UnsupportedOperationException();
    }

    static RuntimeException unsupportedOperation(String msg) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new UnsupportedOperationException(msg);
    }

    static RuntimeException illegalArgument(String msg) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IllegalArgumentException(msg);
    }

    static RuntimeException illegalArgument(String formatString, int n) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IllegalArgumentException(String.format(formatString, n));
    }

    static RuntimeException illegalByteArrayLength(String formatString, int n) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new TruffleString.IllegalByteArrayLengthException(String.format(formatString, n));
    }

    static RuntimeException illegalState(String msg) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IllegalStateException(msg);
    }

    static RuntimeException wrongEncoding(TruffleString.Encoding expectedEncoding) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new IllegalArgumentException("the given string is not compatible to the expected encoding \"" + String.valueOf((Object)expectedEncoding) + "\", did you forget to convert it?");
    }

    static RuntimeException unknownEncoding(String name) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return InternalErrors.illegalArgument("unknown encoding: \"" + name + "\"");
    }

    public static RuntimeException nativeAccessRequired() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return new UnsupportedOperationException("this operation requires native access!");
    }

    @CompilerDirectives.TruffleBoundary
    static OutOfMemoryError outOfMemory() {
        return new OutOfMemoryError();
    }
}

