/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Layout;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Obsolescence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.PropertyMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Transition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.UnsafeAccess;

final class ShapeExt
extends ShapeImpl {
    private volatile ShapeImpl successorShape;
    private volatile Object predecessorShape;
    private static final VarHandle PREDECESSOR_SHAPE_UPDATER;

    ShapeExt(Layout layout, Object sharedData, Object objectType, int flags, Assumption singleContextAssumption) {
        super(layout, objectType, sharedData, flags, singleContextAssumption);
    }

    ShapeExt(Layout layout, Object sharedData, ShapeImpl parent, Object objectType, PropertyMap propertyMap, Transition transition, ShapeImpl.BaseAllocator allocator, int flags) {
        super(layout, parent, objectType, sharedData, propertyMap, transition, allocator, flags);
    }

    @Override
    protected ShapeImpl createShape(Layout layout, Object sharedData, ShapeImpl parent, Object objectType, PropertyMap propertyMap, Transition transition, ShapeImpl.BaseAllocator allocator, int flags) {
        return new ShapeExt(layout, sharedData, parent, objectType, propertyMap, transition, allocator, flags);
    }

    @Override
    public ShapeImpl getRoot() {
        return UnsafeAccess.unsafeCast(super.getRoot(), ShapeImpl.class, true, true);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Shape tryMerge(Shape other) {
        if (this != other && this.isValid() && other.isValid()) {
            return Obsolescence.tryObsoleteDowncast(this, (ShapeImpl)other);
        }
        return null;
    }

    void setSuccessorShape(ShapeImpl successorShape) {
        this.successorShape = successorShape;
    }

    ShapeImpl getSuccessorShape() {
        return this.successorShape;
    }

    void addPredecessorShape(ShapeImpl nextShape) {
        ShapeImpl[] next;
        Object prev;
        do {
            ShapeImpl[] prevArray;
            if ((prev = this.predecessorShape) == null) {
                next = nextShape;
                continue;
            }
            if (prev instanceof ShapeImpl) {
                ShapeImpl prevShape = (ShapeImpl)prev;
                if (prevShape == nextShape) break;
                next = new ShapeImpl[]{prevShape, nextShape};
                continue;
            }
            for (ShapeImpl prevShape : prevArray = (ShapeImpl[])prev) {
                if (prevShape == nextShape) break;
            }
            ShapeImpl[] nextArray = Arrays.copyOf(prevArray, prevArray.length + 1);
            nextArray[prevArray.length] = nextShape;
            next = nextArray;
        } while (!PREDECESSOR_SHAPE_UPDATER.compareAndSet(this, prev, next));
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            PREDECESSOR_SHAPE_UPDATER = lookup.findVarHandle(ShapeExt.class, "predecessorShape", Object.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

