/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtAllocator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ExtLayoutStrategy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ShapeImpl;

final class ExtDefaultStrategy
extends ExtLayoutStrategy {
    private static final ExtDefaultStrategy SINGLETON = new ExtDefaultStrategy();

    private ExtDefaultStrategy() {
    }

    public static ExtDefaultStrategy singleton() {
        return SINGLETON;
    }

    @Override
    public boolean updateShape(DynamicObject object) {
        assert (object.getShape().isValid());
        return false;
    }

    @Override
    public ShapeImpl ensureValid(ShapeImpl newShape) {
        assert (newShape.isValid());
        return newShape;
    }

    @Override
    public ShapeImpl ensureSpace(ShapeImpl shape, Location location) {
        Objects.requireNonNull(location);
        assert (ExtDefaultStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    protected ShapeImpl.BaseAllocator createAllocator(ShapeImpl shape) {
        return new DefaultAllocatorImpl(shape);
    }

    @Override
    protected ShapeImpl.BaseAllocator createAllocator(LayoutImpl layout) {
        return new DefaultAllocatorImpl(layout);
    }

    static class DefaultAllocatorImpl
    extends ExtAllocator {
        DefaultAllocatorImpl(LayoutImpl layout) {
            super(layout);
        }

        DefaultAllocatorImpl(ShapeImpl shape) {
            super(shape);
        }
    }
}

