/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object;

import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.CoreLocation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.FieldInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.IncompatibleLocationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LocationImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.ObjectStorageOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.UnsafeAccess;

abstract class CoreLocations {
    static final int LONG_FIELD_SLOT_SIZE = 1;
    static final int LONG_ARRAY_SLOT_SIZE = 2;
    static final int OBJECT_SLOT_SIZE = 1;
    static final int MAX_DYNAMIC_FIELDS = 1000;

    CoreLocations() {
    }

    static LongLocation createLongLocation(LongLocation longLocation, boolean allowInt) {
        if (!allowInt && longLocation instanceof LongLocationDecorator || longLocation instanceof LongLocationDecorator && ((LongLocationDecorator)longLocation).allowInt == allowInt) {
            return longLocation;
        }
        return new LongLocationDecorator(longLocation, allowInt);
    }

    static long decodeLong(int lower, int upper) {
        return (long)lower & 0xFFFFFFFFL | (long)upper << 32;
    }

    static int lowerInt(long value) {
        return (int)value;
    }

    static int upperInt(long value) {
        return (int)(value >>> 32);
    }

    static int getLocationOrdinal(CoreLocation loc) {
        LocationImpl internal = loc.getInternalLocation();
        boolean isPrimitive = internal instanceof LongLocation;
        if (internal instanceof FieldLocation) {
            return (isPrimitive ? -2147483647 : 0) + ((FieldLocation)internal).getIndex();
        }
        if (internal instanceof ArrayLocation) {
            return (isPrimitive ? -2147483647 : 0) + 1000 + ((ArrayLocation)internal).getIndex();
        }
        throw new IllegalArgumentException(internal.getClass().getName());
    }

    static class LongLocationDecorator
    extends PrimitiveLocationDecorator
    implements LongLocation {
        protected final boolean allowInt;

        protected LongLocationDecorator(LongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.getLong(store, guard);
        }

        @Override
        public long getLong(DynamicObject store, boolean guard) {
            return super.getLongInternal(store, guard);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongLocationDecorator.incompatibleLocation();
            }
            this.setLong(store, this.longValue(value), guard, init);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
            super.setLongInternal(store, value, guard);
        }

        private long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            return ((Integer)value).longValue();
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongLocationDecorator)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }
    }

    public static interface LongLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LongLocation {
        @Override
        public long getLong(DynamicObject var1, boolean var2);

        public void setLong(DynamicObject var1, long var2, boolean var4, boolean var5);

        default public Class<Long> getType() {
            return Long.TYPE;
        }

        public boolean isImplicitCastIntToLong();

        @Override
        default public long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, store.getShape() == shape);
        }

        @Override
        default public void setLong(DynamicObject store, long value, Shape shape) {
            this.setLong(store, value, store.getShape() == shape, false);
        }
    }

    public static abstract class FieldLocation
    extends InstanceLocation {
        protected final FieldInfo field;
        protected final VarHandle varHandle;

        protected FieldLocation(int index, FieldInfo field) {
            super(index);
            this.field = Objects.requireNonNull(field);
            this.varHandle = ObjectStorageOptions.UseVarHandle ? Objects.requireNonNull(field.varHandle()) : null;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            FieldLocation other = (FieldLocation)obj;
            return this.index == other.index;
        }

        @Override
        public String getWhereString() {
            return "@" + this.index;
        }

        protected static DynamicObject receiverCast(DynamicObject store, Class<? extends DynamicObject> tclass) {
            try {
                return tclass.cast(Objects.requireNonNull(store));
            }
            catch (ClassCastException | NullPointerException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw FieldLocation.illegalReceiver(store, tclass);
            }
        }

        protected static IllegalArgumentException illegalReceiver(DynamicObject store, Class<? extends DynamicObject> declaringClass) {
            CompilerAsserts.neverPartOfCompilation();
            return new IllegalArgumentException("Invalid receiver type (expected " + String.valueOf(declaringClass) + ", was " + String.valueOf(store == null ? null : store.getClass()) + ")");
        }
    }

    public static abstract class ArrayLocation
    extends InstanceLocation {
        protected ArrayLocation(int index) {
            super(index);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ArrayLocation other = (ArrayLocation)obj;
            return this.index == other.index;
        }

        @Override
        public String getWhereString() {
            return "[" + this.index + "]";
        }
    }

    static class BooleanLocationDecorator
    extends PrimitiveLocationDecorator
    implements BooleanLocation {
        protected BooleanLocationDecorator(LongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.getBoolean(store, guard);
        }

        @Override
        public boolean getBoolean(DynamicObject store, boolean guard) {
            return this.getLongInternal(store, guard) != 0L;
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value, boolean guard, boolean init) {
            this.setLongInternal(store, value ? 1L : 0L, guard);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw BooleanLocationDecorator.incompatibleLocation();
            }
            this.setBoolean(store, (Boolean)value, guard, init);
        }

        @Override
        public final boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, BooleanLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Boolean;
        }

        @Override
        public Class<Boolean> getType() {
            return Boolean.TYPE;
        }
    }

    static class DoubleLocationDecorator
    extends PrimitiveLocationDecorator
    implements DoubleLocation {
        private final boolean allowInt;

        protected DoubleLocationDecorator(LongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.getDouble(store, guard);
        }

        @Override
        public double getDouble(DynamicObject store, boolean guard) {
            return Double.longBitsToDouble(this.getLongInternal(store, guard));
        }

        @Override
        public void setDouble(DynamicObject store, double value, boolean guard, boolean init) {
            this.setLongInternal(store, Double.doubleToRawLongBits(value), guard);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw DoubleLocationDecorator.incompatibleLocation();
            }
            this.setDouble(store, this.doubleValue(value), guard, init);
        }

        private double doubleValue(Object value) {
            if (!this.allowInt || value instanceof Double) {
                return (Double)value;
            }
            return ((Integer)value).doubleValue();
        }

        @Override
        public final double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, DoubleLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Double || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((DoubleLocationDecorator)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToDouble() {
            return this.allowInt;
        }
    }

    static class IntLocationDecorator
    extends PrimitiveLocationDecorator
    implements IntLocation {
        protected IntLocationDecorator(LongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.getInt(store, guard);
        }

        @Override
        public int getInt(DynamicObject store, boolean guard) {
            return (int)this.getLongInternal(store, guard);
        }

        @Override
        public void setInt(DynamicObject store, int value, boolean guard, boolean init) {
            this.setLongInternal(store, value, guard);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw IntLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Integer)value).intValue(), guard);
        }

        @Override
        public final int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, IntLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Integer;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }
    }

    public static abstract class PrimitiveLocationDecorator
    extends CoreLocation {
        private final LongLocation longLocation;

        protected PrimitiveLocationDecorator(LongLocation longLocation) {
            this.longLocation = longLocation;
        }

        public final long getLongInternal(DynamicObject store, boolean guard) {
            return this.longLocation.getLong(store, guard);
        }

        public final void setLongInternal(DynamicObject store, long value, boolean guard) {
            this.longLocation.setLong(store, value, guard, true);
        }

        public final LongLocation getInternalLongLocation() {
            return this.longLocation;
        }

        @Override
        protected final LocationImpl getInternalLocation() {
            return (LocationImpl)((Object)this.longLocation);
        }

        @Override
        public final int primitiveFieldCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveFieldCount();
        }

        @Override
        public final int primitiveArrayCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveArrayCount();
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            ((LocationImpl)((Object)this.longLocation)).accept(locationVisitor);
        }

        @Override
        public String getWhereString() {
            return ((LocationImpl)((Object)this.longLocation)).getWhereString();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.longLocation.equals(((PrimitiveLocationDecorator)obj).longLocation);
        }

        @Override
        public int hashCode() {
            return this.longLocation.hashCode();
        }
    }

    static final class SimpleLongFieldLocation
    extends FieldLocation
    implements LongLocation {
        SimpleLongFieldLocation(int index, FieldInfo field) {
            super(index, field);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return this.getLong(store, guard);
        }

        @Override
        public void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw SimpleLongFieldLocation.incompatibleLocation();
            }
            this.setLong(store, (Long)value, guard, init);
        }

        @Override
        public boolean canStore(Object value) {
            return value instanceof Long;
        }

        @Override
        public long getLong(DynamicObject store, boolean guard) {
            if (ObjectStorageOptions.UseVarHandle) {
                return this.varHandle.get(store);
            }
            return UnsafeAccess.unsafeGetLong(SimpleLongFieldLocation.receiverCast(store, this.field.getDeclaringClass()), this.field.offset());
        }

        @Override
        public long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, SimpleLongFieldLocation.checkShape(store, shape));
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
            if (ObjectStorageOptions.UseVarHandle) {
                this.varHandle.set(store, value);
                return;
            }
            UnsafeAccess.unsafePutLong(SimpleLongFieldLocation.receiverCast(store, this.field.getDeclaringClass()), this.field.offset(), value);
        }

        @Override
        public int primitiveFieldCount() {
            return 1;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return false;
        }
    }

    static class LongArrayLocation
    extends ArrayLocation
    implements LongLocation {
        private static final int ALIGN = 1;
        protected final boolean allowInt;

        protected LongArrayLocation(int index, boolean allowInt) {
            super(index);
            this.allowInt = allowInt;
        }

        protected LongArrayLocation(int index) {
            this(index, false);
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.getLong(store, guard);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongArrayLocation.incompatibleLocation();
            }
            this.setLong(store, this.longValue(value), guard, init);
        }

        private long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            return ((Integer)value).longValue();
        }

        protected static final int[] getArray(DynamicObject store) {
            return store.getPrimitiveStore();
        }

        @Override
        public long getLong(DynamicObject store, boolean guard) {
            boolean boundsCheck;
            int[] array = LongArrayLocation.getArray(store);
            int idx = this.index;
            boolean bl = boundsCheck = idx >= 0 && idx < array.length - 1;
            if (boundsCheck) {
                long offset = UnsafeAccess.ARRAY_INT_BASE_OFFSET + UnsafeAccess.ARRAY_INT_INDEX_SCALE * (long)idx;
                return UnsafeAccess.unsafeGetLong(array, offset, boundsCheck, null);
            }
            throw LongArrayLocation.arrayIndexOutOfBounds(idx);
        }

        public final void setLongInternal(DynamicObject store, long value) {
            int[] array = LongArrayLocation.getArray(store);
            int idx = this.index;
            if (idx < 0 || idx >= array.length - 1) {
                throw LongArrayLocation.arrayIndexOutOfBounds(idx);
            }
            long offset = UnsafeAccess.ARRAY_INT_BASE_OFFSET + UnsafeAccess.ARRAY_INT_INDEX_SCALE * (long)idx;
            UnsafeAccess.unsafePutLong(array, offset, value, null);
        }

        private static ArrayIndexOutOfBoundsException arrayIndexOutOfBounds(int idx) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new ArrayIndexOutOfBoundsException(idx);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
            this.setLongInternal(store, value);
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 2;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.getIndex(), 2);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongArrayLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }
    }

    static final class SimpleObjectFieldLocation
    extends FieldLocation
    implements ObjectLocation {
        SimpleObjectFieldLocation(int index, FieldInfo field) {
            super(index, field);
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            if (ObjectStorageOptions.UseVarHandle) {
                return this.varHandle.get(store);
            }
            return UnsafeAccess.unsafeGetObject(SimpleObjectFieldLocation.receiverCast(store, this.field.getDeclaringClass()), this.field.offset());
        }

        @Override
        public void set(DynamicObject store, Object value, boolean guard, boolean init) {
            if (ObjectStorageOptions.UseVarHandle) {
                this.varHandle.set(store, value);
                return;
            }
            UnsafeAccess.unsafePutObject(SimpleObjectFieldLocation.receiverCast(store, this.field.getDeclaringClass()), this.field.offset(), value);
        }

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        protected void clear(DynamicObject store) {
            this.set(store, null, false, true);
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectField(this.getIndex(), 1);
        }
    }

    static class ObjectArrayLocation
    extends ArrayLocation
    implements ObjectLocation {
        protected ObjectArrayLocation(int index) {
            super(index);
        }

        protected static final Object[] getArray(DynamicObject store) {
            return store.getObjectStore();
        }

        @Override
        public Object get(DynamicObject store, boolean guard) {
            return ObjectArrayLocation.getArray(store)[this.index];
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) {
            ObjectArrayLocation.getArray((DynamicObject)store)[this.index] = value;
        }

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public final boolean isNonNull() {
            return false;
        }

        @Override
        protected void clear(DynamicObject store) {
            this.set(store, null, false, true);
        }

        @Override
        public int objectArrayCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectArray(this.index, 1);
        }
    }

    static abstract class InstanceLocation
    extends CoreLocation {
        protected final int index;

        protected InstanceLocation(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }
    }

    public static final class DeclaredLocation
    extends ValueLocation {
        DeclaredLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isDeclared() {
            return true;
        }
    }

    public static final class ConstantLocation
    extends ValueLocation {
        ConstantLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static abstract class ValueLocation
    extends CoreLocation {
        private final Object value;

        ValueLocation(Object value) {
            assert (!(value instanceof Location));
            this.value = value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.value, ((ValueLocation)obj).value);
        }

        @Override
        public final Object get(DynamicObject store, boolean guard) {
            return this.value;
        }

        @Override
        public boolean canStore(Object val) {
            return ValueLocation.valueEquals(this.value, val);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean guard, boolean init) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                if (init) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new UnsupportedOperationException();
                }
                throw ValueLocation.incompatibleLocation();
            }
        }

        @Override
        public String toString() {
            return "=" + String.valueOf(this.value);
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
        }

        @Override
        public final boolean isValue() {
            return true;
        }
    }

    public static interface BooleanLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.BooleanLocation {
        @Override
        public boolean getBoolean(DynamicObject var1, boolean var2);

        public void setBoolean(DynamicObject var1, boolean var2, boolean var3, boolean var4);

        default public Class<Boolean> getType() {
            return Boolean.TYPE;
        }

        @Override
        default public boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, store.getShape() == shape);
        }

        @Override
        default public void setBoolean(DynamicObject store, boolean value, Shape shape) {
            this.setBoolean(store, value, store.getShape() == shape, false);
        }
    }

    public static interface DoubleLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DoubleLocation {
        @Override
        public double getDouble(DynamicObject var1, boolean var2);

        public void setDouble(DynamicObject var1, double var2, boolean var4, boolean var5);

        default public Class<Double> getType() {
            return Double.TYPE;
        }

        public boolean isImplicitCastIntToDouble();

        @Override
        default public double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, store.getShape() == shape);
        }

        @Override
        default public void setDouble(DynamicObject store, double value, Shape shape) {
            this.setDouble(store, value, store.getShape() == shape, false);
        }
    }

    public static interface IntLocation
    extends TypedLocation,
    org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.IntLocation {
        @Override
        public int getInt(DynamicObject var1, boolean var2);

        public void setInt(DynamicObject var1, int var2, boolean var3, boolean var4);

        default public Class<Integer> getType() {
            return Integer.TYPE;
        }

        @Override
        default public int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, store.getShape() == shape);
        }

        @Override
        default public void setInt(DynamicObject store, int value, Shape shape) {
            this.setInt(store, value, store.getShape() == shape, false);
        }
    }

    public static interface ObjectLocation
    extends TypedLocation {
        public Class<? extends Object> getType();

        public boolean isNonNull();
    }

    public static interface TypedLocation {
        public Class<?> getType();
    }
}

