/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl;

import java.util.Arrays;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;

public final class UnsupportedSpecializationException
extends RuntimeException {
    private static final long serialVersionUID = -2122892028296836269L;
    private final Node node;
    private final Node[] suppliedNodes;
    private final Object[] suppliedValues;

    @CompilerDirectives.TruffleBoundary
    public UnsupportedSpecializationException(Node node, Node[] suppliedNodes, Object ... suppliedValues) {
        Objects.requireNonNull(suppliedValues, "suppliedValues");
        if (suppliedNodes != null && suppliedNodes.length != suppliedValues.length) {
            throw new IllegalArgumentException("The length of suppliedNodes must match the length of suppliedValues.");
        }
        this.node = node;
        this.suppliedNodes = suppliedNodes;
        this.suppliedValues = suppliedValues;
    }

    @Override
    public String getMessage() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder();
        Object[] values = this.getSuppliedValues();
        str.append("Unexpected values provided for ").append(this.node).append(": ").append(Arrays.toString(values)).append(", [");
        for (int i = 0; i < values.length; ++i) {
            str.append(i == 0 ? "" : ",").append(values[i] == null ? "null" : values[i].getClass().getSimpleName());
        }
        return str.append("]").toString();
    }

    public Node getNode() {
        return this.node;
    }

    @CompilerDirectives.TruffleBoundary
    public Node[] getSuppliedNodes() {
        if (this.suppliedNodes == null) {
            return new Node[this.getSuppliedValues().length];
        }
        return this.suppliedNodes;
    }

    public Object[] getSuppliedValues() {
        return this.suppliedValues;
    }
}

