/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.DefaultBytecodeScope;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.SourceInformation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTree;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTreeNodeExports;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.DynamicDispatchLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=DynamicDispatchLibrary.class)
public abstract class TagTreeNode
extends Node
implements TagTree {
    protected TagTreeNode(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    protected abstract Class<? extends TruffleLanguage<?>> getLanguage();

    @ExportMessage
    protected Class<?> dispatch() {
        return TagTreeNodeExports.class;
    }

    public BytecodeNode getBytecodeNode() {
        return BytecodeNode.get(this);
    }

    public final Object createDefaultScope(Frame frame, boolean nodeEnter) {
        return new DefaultBytecodeScope(this, frame, nodeEnter);
    }

    @Override
    public final String toString() {
        SourceSection section;
        StringBuilder b = new StringBuilder();
        b.append(TagTreeNode.format(this));
        if (this.getParent() != null && (section = this.getSourceSection()) != null) {
            b.append(" ");
            b.append(SourceInformation.formatSourceSection(section, 60));
        }
        return b.toString();
    }

    static String format(TagTreeNode b) {
        return String.format("(%04x .. %04x %s)", b.getEnterBytecodeIndex(), b.getReturnBytecodeIndex(), b.getTagsString());
    }

    final String getTagsString() {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (Class<? extends Tag> tag : this.getTags()) {
            String tagId = Tag.getIdentifier(tag);
            if (tagId == null) {
                tagId = tag.getSimpleName();
            }
            b.append(sep);
            b.append(tagId);
            sep = ",";
        }
        return b.toString();
    }
}

