/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

public abstract class SourceInformation {
    protected SourceInformation(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    public abstract int getStartBytecodeIndex();

    public abstract int getEndBytecodeIndex();

    public abstract SourceSection getSourceSection();

    public String toString() {
        SourceSection sourceSection = this.getSourceSection();
        String sourceText = sourceSection == null ? "<none>" : SourceInformation.formatSourceSection(sourceSection, 60);
        return String.format("[%04x .. %04x] %s", this.getStartBytecodeIndex(), this.getEndBytecodeIndex(), sourceText);
    }

    static final String formatSourceSection(SourceSection section, int maxCharacters) {
        String characters;
        if (section.getSource().hasCharacters()) {
            characters = SourceInformation.limitCharacters(section.getCharacters(), maxCharacters).toString();
            characters = characters.replace("\n", "\\n");
        } else {
            characters = "";
        }
        return String.format("%s %3s:%-3s-%3s:%-3s   %s", SourceInformation.limitCharacters(section.getSource().getName(), 40), section.getStartLine(), section.getStartColumn(), section.getEndLine(), section.getEndColumn(), characters);
    }

    private static CharSequence limitCharacters(CharSequence characters, int maxCharacters) {
        if (characters.length() > maxCharacters) {
            return characters.subSequence(0, maxCharacters - 3).toString() + "...";
        }
        return characters;
    }
}

