/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeLocal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;

public final class MaterializedLocalAccessor {
    private final int rootIndex;
    private final int localOffset;
    private final int localIndex;
    private static final int CACHE_SIZE = 64;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final MaterializedLocalAccessor[] CACHE = MaterializedLocalAccessor.createCache();

    private MaterializedLocalAccessor(int rootIndex, int localOffset, int localIndex) {
        this.rootIndex = rootIndex;
        this.localOffset = localOffset;
        this.localIndex = localIndex;
    }

    public String toString() {
        return String.format("MaterializedLocalAccessor[rootIndex=%d, localOffset=%d, localIndex=%d]", this.rootIndex, this.localOffset, this.localIndex);
    }

    public Object getObject(BytecodeNode bytecodeNode, MaterializedFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternal(frame, this.localOffset, this.localIndex);
    }

    public boolean getBoolean(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalBoolean(frame, this.localOffset, this.localIndex);
    }

    public byte getByte(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalByte(frame, this.localOffset, this.localIndex);
    }

    public int getInt(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalInt(frame, this.localOffset, this.localIndex);
    }

    public long getLong(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalLong(frame, this.localOffset, this.localIndex);
    }

    public float getFloat(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalFloat(frame, this.localOffset, this.localIndex);
    }

    public double getDouble(BytecodeNode bytecodeNode, MaterializedFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalValueInternalDouble(frame, this.localOffset, this.localIndex);
    }

    public void setObject(BytecodeNode bytecodeNode, MaterializedFrame frame, Object value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternal(frame, this.localOffset, this.localIndex, value);
    }

    public void setBoolean(BytecodeNode bytecodeNode, MaterializedFrame frame, boolean value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalBoolean(frame, this.localOffset, this.localIndex, value);
    }

    public void setByte(BytecodeNode bytecodeNode, MaterializedFrame frame, byte value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalByte(frame, this.localOffset, this.localIndex, value);
    }

    public void setInt(BytecodeNode bytecodeNode, MaterializedFrame frame, int value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalInt(frame, this.localOffset, this.localIndex, value);
    }

    public void setLong(BytecodeNode bytecodeNode, MaterializedFrame frame, long value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalLong(frame, this.localOffset, this.localIndex, value);
    }

    public void setFloat(BytecodeNode bytecodeNode, MaterializedFrame frame, float value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalFloat(frame, this.localOffset, this.localIndex, value);
    }

    public void setDouble(BytecodeNode bytecodeNode, MaterializedFrame frame, double value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.setLocalValueInternalDouble(frame, this.localOffset, this.localIndex, value);
    }

    public void clear(BytecodeNode bytecodeNode, MaterializedFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        declaringBytecodeNode.clearLocalValueInternal(frame, this.localOffset, this.localIndex);
    }

    public boolean isCleared(BytecodeNode bytecodeNode, MaterializedFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.isLocalClearedInternal(frame, this.localOffset, this.localIndex);
    }

    public Object getLocalName(BytecodeNode bytecodeNode) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalNameInternal(this.localOffset, this.localIndex);
    }

    public Object getLocalInfo(BytecodeNode bytecodeNode) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        BytecodeNode declaringBytecodeNode = ((BytecodeRootNode)bytecodeNode.getBytecodeRootNode().getRootNodes().getNode(this.rootIndex)).getBytecodeNode();
        CompilerAsserts.partialEvaluationConstant(declaringBytecodeNode);
        return declaringBytecodeNode.getLocalInfoInternal(this.localOffset, this.localIndex);
    }

    private static MaterializedLocalAccessor[] createCache() {
        MaterializedLocalAccessor[] setters = new MaterializedLocalAccessor[64];
        for (int i = 0; i < setters.length; ++i) {
            setters[i] = new MaterializedLocalAccessor(0, i, i);
        }
        return setters;
    }

    public static MaterializedLocalAccessor constantOf(int rootIndex, BytecodeLocal local) {
        int offset = local.getLocalOffset();
        int index = local.getLocalIndex();
        assert (offset <= index);
        if (rootIndex == 0 && index == offset && offset < 64) {
            return CACHE[offset];
        }
        return new MaterializedLocalAccessor(rootIndex, offset, index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MaterializedLocalAccessor)) return false;
        MaterializedLocalAccessor otherAccessor = (MaterializedLocalAccessor)obj;
        if (this.rootIndex != otherAccessor.rootIndex) return false;
        if (this.localOffset != otherAccessor.localOffset) return false;
        if (this.localIndex != otherAccessor.localIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.rootIndex, this.localOffset, this.localIndex);
    }
}

