/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeLocation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.SourceInformation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTreeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Introspection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@Bind.DefaultExpression(value="$bytecodeNode.getInstruction($bytecodeIndex)")
public abstract class Instruction {
    protected Instruction(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    public abstract BytecodeNode getBytecodeNode();

    public abstract int getBytecodeIndex();

    public abstract int getLength();

    public final BytecodeLocation getLocation() {
        return this.getBytecodeNode().getBytecodeLocation(this.getBytecodeIndex());
    }

    public abstract String getName();

    public abstract int getOperationCode();

    public abstract List<Argument> getArguments();

    public abstract boolean isInstrumentation();

    public final SourceSection getSourceSection() {
        BytecodeNode bytecode = this.getBytecodeNode();
        if (bytecode == null || bytecode.getSourceInformation() == null) {
            return null;
        }
        return bytecode.getSourceLocation(this.getBytecodeIndex());
    }

    public final SourceSection[] getSourceSections() {
        BytecodeNode bytecode = this.getBytecodeNode();
        if (bytecode == null || bytecode.getSourceInformation() == null) {
            return null;
        }
        return this.getBytecodeNode().getSourceLocations(this.getBytecodeIndex());
    }

    public final int getNextBytecodeIndex() {
        return this.getBytecodeIndex() + this.getLength();
    }

    protected abstract Instruction next();

    public final int hashCode() {
        return Objects.hash(this.getBytecodeNode(), this.getBytecodeIndex(), this.getOperationCode());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Instruction) {
            Instruction other = (Instruction)obj;
            return this.getBytecodeNode() == other.getBytecodeNode() && this.getBytecodeIndex() == other.getBytecodeIndex() && this.getOperationCode() == other.getOperationCode();
        }
        return false;
    }

    public final String toString() {
        return Instruction.formatInstruction(null, -1, this, 40, 60);
    }

    static String formatInstruction(List<Throwable> errors, int index, Instruction instruction, int maxLabelWidth, int maxArgumentWidth) {
        StringBuilder sb = new StringBuilder();
        if (index != -1) {
            sb.append(String.format("%3d ", index));
        }
        String label = Instruction.formatLabel(instruction);
        sb.append(label);
        Instruction.appendSpaces(sb, maxLabelWidth - label.length());
        String arguments = Instruction.formatArguments(instruction);
        sb.append(arguments);
        Instruction.appendSpaces(sb, maxArgumentWidth - arguments.length());
        try {
            SourceSection s = instruction.getSourceSection();
            if (s != null) {
                sb.append(" | ");
                sb.append(SourceInformation.formatSourceSection(s, 60));
            }
        }
        catch (Throwable t) {
            if (errors != null) {
                errors.add(t);
                sb.append(" | " + t.toString());
            }
            throw t;
        }
        return sb.toString();
    }

    private static void appendSpaces(StringBuilder sb, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
    }

    static String formatLabel(Instruction instruction) {
        return String.format("[%03x] %03x %s", instruction.getBytecodeIndex(), instruction.getOperationCode(), instruction.getName());
    }

    static String formatArguments(Instruction instruction) {
        StringBuilder b = new StringBuilder(" ");
        for (Argument a : instruction.getArguments()) {
            b.append(' ').append(a.toString());
        }
        return b.toString();
    }

    public static abstract class Argument {
        protected Argument(Object token) {
            BytecodeRootNodes.checkToken(token);
        }

        public abstract Kind getKind();

        public abstract String getName();

        public int asInteger() throws UnsupportedOperationException {
            throw this.unsupported();
        }

        public int asBytecodeIndex() {
            throw this.unsupported();
        }

        public Object asConstant() {
            throw this.unsupported();
        }

        public Node asCachedNode() {
            throw this.unsupported();
        }

        public TagTreeNode asTagNode() {
            throw this.unsupported();
        }

        public int asLocalOffset() {
            throw this.unsupported();
        }

        public int asLocalIndex() {
            throw this.unsupported();
        }

        public BranchProfile asBranchProfile() {
            throw this.unsupported();
        }

        public final List<Introspection.SpecializationInfo> getSpecializationInfo() {
            Node n = this.asCachedNode();
            if (Introspection.isIntrospectable(n)) {
                return Introspection.getSpecializations(n);
            }
            return null;
        }

        private RuntimeException unsupported() {
            return new UnsupportedOperationException(String.format("Not supported for argument type %s.", new Object[]{this.getKind()}));
        }

        public final String toString() {
            switch (this.getKind().ordinal()) {
                case 3: {
                    return String.format("%s(%d)", this.getName(), this.asLocalOffset());
                }
                case 4: {
                    return String.format("%s(%d)", this.getName(), this.asLocalIndex());
                }
                case 2: {
                    return String.format("%s(%d)", this.getName(), this.asInteger());
                }
                case 0: {
                    return String.format("%s(%s)", this.getName(), Argument.printConstant(this.asConstant()));
                }
                case 5: {
                    return String.format("%s(%s)", this.getName(), this.printNodeProfile(this.asCachedNode()));
                }
                case 1: {
                    return String.format("%s(%04x)", this.getName(), this.asBytecodeIndex());
                }
                case 6: {
                    return String.format("%s(%s)", this.getName(), this.asBranchProfile());
                }
                case 7: {
                    return String.format("%s%s", this.getName(), Argument.printTagProfile(this.asTagNode()));
                }
            }
            throw new UnsupportedOperationException("Unexpected argument kind " + String.valueOf((Object)this.getKind()));
        }

        private static String printTagProfile(TagTreeNode o) {
            if (o == null) {
                return "null";
            }
            return TagTreeNode.format(o);
        }

        private String printNodeProfile(Object o) {
            StringBuilder sb = new StringBuilder();
            if (o == null) {
                return "null";
            }
            sb.append(o.getClass().getSimpleName());
            List<Introspection.SpecializationInfo> info = this.getSpecializationInfo();
            if (info != null) {
                sb.append("(");
                String sep = "";
                for (Introspection.SpecializationInfo specialization : info) {
                    if (specialization.getInstances() == 0) continue;
                    sb.append(sep);
                    sb.append(specialization.getMethodName());
                    sep = "#";
                }
                sb.append(")");
            }
            return sb.toString();
        }

        private static String printConstant(Object value) {
            Object valueString;
            if (value == null) {
                return "null";
            }
            String typeString = value.getClass().getSimpleName();
            Object object = valueString = value.getClass().isArray() ? Argument.printArray(value) : value.toString();
            if (((String)valueString).length() > 100) {
                valueString = ((String)valueString).substring(0, 97) + "...";
            }
            return String.format("%s %s", typeString, valueString);
        }

        private static String printArray(Object array) {
            if (array instanceof Object[]) {
                Object[] objArr = (Object[])array;
                return Arrays.toString(objArr);
            }
            if (array instanceof long[]) {
                long[] longArr = (long[])array;
                return Arrays.toString(longArr);
            }
            if (array instanceof int[]) {
                int[] intArr = (int[])array;
                return Arrays.toString(intArr);
            }
            if (array instanceof short[]) {
                short[] shortArr = (short[])array;
                return Arrays.toString(shortArr);
            }
            if (array instanceof char[]) {
                char[] charArr = (char[])array;
                return Arrays.toString(charArr);
            }
            if (array instanceof byte[]) {
                byte[] byteArr = (byte[])array;
                return Arrays.toString(byteArr);
            }
            if (array instanceof double[]) {
                double[] doubleArr = (double[])array;
                return Arrays.toString(doubleArr);
            }
            if (array instanceof float[]) {
                float[] floatArr = (float[])array;
                return Arrays.toString(floatArr);
            }
            if (array instanceof boolean[]) {
                boolean[] boolArr = (boolean[])array;
                return Arrays.toString(boolArr);
            }
            throw new AssertionError((Object)String.format("Unhandled array type %s", array));
        }

        public static enum Kind {
            CONSTANT,
            BYTECODE_INDEX,
            INTEGER,
            LOCAL_OFFSET,
            LOCAL_INDEX,
            NODE_PROFILE,
            BRANCH_PROFILE,
            TAG_NODE;

        }

        public record BranchProfile(int index, int trueCount, int falseCount) {
            public double getFrequency() {
                int total = this.trueCount + this.falseCount;
                if (total == 0) {
                    return 0.0;
                }
                return (double)this.trueCount / (double)total;
            }

            @Override
            public String toString() {
                if (this.trueCount + this.falseCount == 0) {
                    return this.index + ":never executed";
                }
                return String.format("%s:%.2f", this.index, this.getFrequency());
            }
        }
    }

    private static final class InstructionIterator
    implements Iterator<Instruction> {
        private Instruction current;

        InstructionIterator(Instruction start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Instruction next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Instruction next = this.current;
            this.current = next.next();
            return next;
        }
    }

    static final class InstructionIterable
    implements Iterable<Instruction> {
        private final BytecodeNode bytecodeNode;

        InstructionIterable(BytecodeNode bytecodeNode) {
            this.bytecodeNode = bytecodeNode;
        }

        @Override
        public Iterator<Instruction> iterator() {
            return new InstructionIterator(this.bytecodeNode.findInstruction(0));
        }
    }
}

