/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTree;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTreeNode;

public abstract class ExceptionHandler {
    protected ExceptionHandler(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    public abstract HandlerKind getKind();

    public abstract int getStartBytecodeIndex();

    public abstract int getEndBytecodeIndex();

    public int getHandlerBytecodeIndex() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getHandlerIndex() is not supported for handler kind: " + String.valueOf((Object)this.getKind()));
    }

    public TagTree getTagTree() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getTagTree() is not supported for handler kind: " + String.valueOf((Object)this.getKind()));
    }

    public final String toString() {
        return String.format("[%04x .. %04x] %s", this.getStartBytecodeIndex(), this.getEndBytecodeIndex(), switch (this.getKind().ordinal()) {
            case 0 -> String.format("handler %04x", this.getHandlerBytecodeIndex());
            case 2 -> "epilog.exceptional";
            case 1 -> String.format("tag.exceptional %s", ((TagTreeNode)this.getTagTree()).getTagsString());
            default -> throw new AssertionError((Object)"Invalid handler kind");
        });
    }

    public static enum HandlerKind {
        CUSTOM,
        TAG,
        EPILOG;

    }
}

