/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeLocation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeTier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.ContinuationRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.DefaultBytecodeStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.ExceptionHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.Instruction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.LocalVariable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.SourceInformation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.SourceInformationTree;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTree;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.TagTreeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameInstance;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@Bind.DefaultExpression(value="$bytecodeNode")
public abstract class BytecodeNode
extends Node {
    protected BytecodeNode(Object token) {
        BytecodeRootNodes.checkToken(token);
    }

    public final BytecodeLocation getBytecodeLocation(Frame frame, Node location) {
        int bytecodeIndex = this.findBytecodeIndexImpl(frame, location);
        if (bytecodeIndex < -1) {
            return null;
        }
        return new BytecodeLocation(this, bytecodeIndex);
    }

    public final BytecodeLocation getBytecodeLocation(FrameInstance frameInstance) {
        int bytecodeIndex = this.findBytecodeIndex(frameInstance);
        if (bytecodeIndex == -1) {
            return null;
        }
        return new BytecodeLocation(this, bytecodeIndex);
    }

    public final BytecodeLocation getBytecodeLocation(int bytecodeIndex) {
        assert (this.validateBytecodeIndex(bytecodeIndex));
        return this.findLocation(bytecodeIndex);
    }

    public int getBytecodeIndex(Frame frame) {
        throw new UnsupportedOperationException("Interpreter does not store the bytecode index in the frame.");
    }

    public final SourceSection getSourceLocation(Frame frame, Node location) {
        int bci = this.findBytecodeIndexImpl(frame, location);
        if (bci == -1) {
            return null;
        }
        return this.getSourceLocation(bci);
    }

    public final SourceSection[] getSourceLocations(Frame frame, Node location) {
        int bci = this.findBytecodeIndexImpl(frame, location);
        if (bci == -1) {
            return null;
        }
        return this.getSourceLocations(bci);
    }

    public abstract SourceSection getSourceLocation(int var1);

    public abstract SourceSection[] getSourceLocations(int var1);

    private int findBytecodeIndexImpl(Frame frame, Node location) {
        Objects.requireNonNull(frame, "Provided frame must not be null.");
        Objects.requireNonNull(location, "Provided location must not be null.");
        Node operationNode = this.findOperationNode(location);
        return this.findBytecodeIndex(frame, operationNode);
    }

    @CompilerDirectives.TruffleBoundary
    private Node findOperationNode(Node location) {
        Node prev = null;
        BytecodeNode bytecode = null;
        for (Node current = location; current != null; current = current.getParent()) {
            if (current == this) {
                bytecode = this;
                break;
            }
            prev = current;
        }
        if (bytecode == null) {
            return null;
        }
        return prev;
    }

    public final SourceSection getSourceLocation(FrameInstance frameInstance) {
        int bci = this.findBytecodeIndex(frameInstance);
        if (bci == -1) {
            return null;
        }
        return this.getSourceLocation(bci);
    }

    public final SourceSection[] getSourceLocations(FrameInstance frameInstance) {
        int bci = this.findBytecodeIndex(frameInstance);
        if (bci == -1) {
            return null;
        }
        return this.getSourceLocations(bci);
    }

    public final BytecodeRootNode getBytecodeRootNode() {
        return (BytecodeRootNode)((Object)this.getParent());
    }

    public final Instruction getInstruction(int bytecodeIndex) {
        assert (this.validateBytecodeIndex(bytecodeIndex));
        return this.findInstruction(bytecodeIndex);
    }

    public final Iterable<Instruction> getInstructions() {
        return new Instruction.InstructionIterable(this);
    }

    public final List<Instruction> getInstructionsAsList() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (Instruction instruction : this.getInstructions()) {
            instructions.add(instruction);
        }
        return instructions;
    }

    public abstract List<SourceInformation> getSourceInformation();

    public abstract SourceInformationTree getSourceInformationTree();

    public final BytecodeNode ensureSourceInformation() {
        if (this.hasSourceInformation()) {
            return this;
        }
        BytecodeRootNode rootNode = this.getBytecodeRootNode();
        rootNode.getRootNodes().update(BytecodeConfig.WITH_SOURCE);
        BytecodeNode newNode = this.getBytecodeRootNode().getBytecodeNode();
        assert (newNode.hasSourceInformation()) : "materialization of sources failed";
        return newNode;
    }

    public abstract boolean hasSourceInformation();

    public abstract List<ExceptionHandler> getExceptionHandlers();

    public abstract TagTree getTagTree();

    @ExplodeLoop
    public final Object[] getLocalValues(int bytecodeIndex, Frame frame) {
        assert (this.validateBytecodeIndex(bytecodeIndex));
        Objects.requireNonNull(frame);
        CompilerAsserts.partialEvaluationConstant(bytecodeIndex);
        int count = this.getLocalCount(bytecodeIndex);
        Object[] locals = new Object[count];
        for (int i = 0; i < count; ++i) {
            locals[i] = this.getLocalValue(bytecodeIndex, frame, i);
        }
        return locals;
    }

    public abstract Object getLocalValue(int var1, Frame var2, int var3);

    @ExplodeLoop
    public final Object[] getLocalNames(int bytecodeIndex) {
        CompilerAsserts.partialEvaluationConstant(bytecodeIndex);
        int count = this.getLocalCount(bytecodeIndex);
        Object[] locals = new Object[count];
        for (int i = 0; i < count; ++i) {
            locals[i] = this.getLocalName(bytecodeIndex, i);
        }
        return locals;
    }

    public abstract Object getLocalName(int var1, int var2);

    @ExplodeLoop
    public final Object[] getLocalInfos(int bytecodeIndex) {
        CompilerAsserts.partialEvaluationConstant(bytecodeIndex);
        int count = this.getLocalCount(bytecodeIndex);
        Object[] locals = new Object[count];
        for (int i = 0; i < count; ++i) {
            locals[i] = this.getLocalInfo(bytecodeIndex, i);
        }
        return locals;
    }

    public abstract Object getLocalInfo(int var1, int var2);

    @ExplodeLoop
    public final void setLocalValues(int bytecodeIndex, Frame frame, Object[] values) {
        CompilerAsserts.partialEvaluationConstant(bytecodeIndex);
        int count = this.getLocalCount(bytecodeIndex);
        if (values.length != count) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of values.");
        }
        for (int i = 0; i < count; ++i) {
            this.setLocalValue(bytecodeIndex, frame, i, values[i]);
        }
    }

    @ExplodeLoop
    public final void copyLocalValues(int bytecodeIndex, Frame source, Frame destination) {
        CompilerAsserts.partialEvaluationConstant(bytecodeIndex);
        int count = this.getLocalCount(bytecodeIndex);
        for (int i = 0; i < count; ++i) {
            this.setLocalValue(bytecodeIndex, destination, i, this.getLocalValue(bytecodeIndex, source, i));
        }
    }

    @ExplodeLoop
    public final void copyLocalValues(int bytecodeIndex, Frame source, Frame destination, int localOffset, int localCount) {
        CompilerAsserts.partialEvaluationConstant(localOffset);
        CompilerAsserts.partialEvaluationConstant(localCount);
        if (localCount < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Negative length not allowed.");
        }
        if (localOffset < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Negative startIndex not allowed.");
        }
        int endLocal = Math.min(localOffset + localCount, this.getLocalCount(bytecodeIndex));
        for (int i = localOffset; i < endLocal; ++i) {
            this.setLocalValue(bytecodeIndex, destination, i, this.getLocalValue(bytecodeIndex, source, i));
        }
    }

    public abstract void setLocalValue(int var1, Frame var2, int var3, Object var4);

    protected abstract Object getLocalValueInternal(Frame var1, int var2, int var3);

    protected boolean getLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Boolean) {
            Boolean i = (Boolean)value;
            return i;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected byte getLocalValueInternalByte(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Byte) {
            Byte i = (Byte)value;
            return i;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected int getLocalValueInternalInt(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected long getLocalValueInternalLong(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Long) {
            Long i = (Long)value;
            return i;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected float getLocalValueInternalFloat(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Float) {
            Float i = (Float)value;
            return i.floatValue();
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected double getLocalValueInternalDouble(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
        Object value = this.getLocalValueInternal(frame, localOffset, localIndex);
        if (value instanceof Double) {
            Double i = (Double)value;
            return i;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    protected abstract void setLocalValueInternal(Frame var1, int var2, int var3, Object var4);

    protected void setLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex, boolean value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, value);
    }

    protected void setLocalValueInternalByte(Frame frame, int localOffset, int localIndex, byte value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, value);
    }

    protected void setLocalValueInternalInt(Frame frame, int localOffset, int localIndex, int value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, value);
    }

    protected void setLocalValueInternalLong(Frame frame, int localOffset, int localIndex, long value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, value);
    }

    protected void setLocalValueInternalFloat(Frame frame, int localOffset, int localIndex, float value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, Float.valueOf(value));
    }

    protected void setLocalValueInternalDouble(Frame frame, int localOffset, int localIndex, double value) {
        this.setLocalValueInternal(frame, localOffset, localIndex, value);
    }

    protected abstract void clearLocalValueInternal(Frame var1, int var2, int var3);

    protected abstract boolean isLocalClearedInternal(Frame var1, int var2, int var3);

    protected abstract Object getLocalNameInternal(int var1, int var2);

    protected abstract Object getLocalInfoInternal(int var1, int var2);

    public abstract int getLocalCount(int var1);

    public abstract List<LocalVariable> getLocals();

    public abstract void setUncachedThreshold(int var1);

    public abstract BytecodeTier getTier();

    public final String dump() {
        return this.dump(null);
    }

    @CompilerDirectives.TruffleBoundary
    public final String dump(int bytecodeIndex) {
        BytecodeLocation location = bytecodeIndex >= 0 ? this.getBytecodeLocation(bytecodeIndex) : null;
        return this.dump(location);
    }

    @CompilerDirectives.TruffleBoundary
    public final String dump(BytecodeLocation highlightedLocation) {
        if (highlightedLocation != null && highlightedLocation.getBytecodeNode() != this) {
            throw new IllegalArgumentException("Invalid highlighted location. Belongs to a different BytecodeNode.");
        }
        List<Instruction> instructions = this.getInstructionsAsList();
        List<ExceptionHandler> exceptions = this.getExceptionHandlers();
        List<LocalVariable> locals = this.getLocals();
        List<SourceInformation> sourceInformation = this.getSourceInformation();
        int highlightedBci = highlightedLocation == null ? -1 : highlightedLocation.getBytecodeIndex();
        int instructionCount = instructions.size();
        int maxLabelSize = Math.min(80, instructions.stream().mapToInt(i -> Instruction.formatLabel(i).length()).max().orElse(0));
        int maxArgumentSize = Math.min(100, instructions.stream().mapToInt(i -> Instruction.formatArguments(i).length()).max().orElse(0));
        record IndexedInstruction(Instruction instruction, int index) {
        }
        ArrayList<IndexedInstruction> indexedInstructions = new ArrayList<IndexedInstruction>(instructions.size());
        for (Instruction i2 : instructions) {
            indexedInstructions.add(new IndexedInstruction(i2, indexedInstructions.size()));
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        String instructionsDump = BytecodeNode.formatList(errors, indexedInstructions, i -> i.instruction().getBytecodeIndex() == highlightedBci, i -> Instruction.formatInstruction(errors, i.index(), i.instruction(), maxLabelSize, maxArgumentSize));
        int exceptionCount = exceptions.size();
        String exceptionDump = BytecodeNode.formatList(errors, exceptions, e -> highlightedBci >= e.getStartBytecodeIndex() && highlightedBci < e.getEndBytecodeIndex(), ExceptionHandler::toString);
        int localsCount = locals.size();
        String localsDump = BytecodeNode.formatList(errors, locals, e -> highlightedBci >= e.getStartIndex() && highlightedBci < e.getEndIndex(), LocalVariable::toString);
        String sourceInfoCount = sourceInformation != null ? String.valueOf(sourceInformation.size()) : "-";
        String sourceDump = BytecodeNode.formatList(errors, sourceInformation, s -> highlightedBci >= s.getStartBytecodeIndex() && highlightedBci < s.getEndBytecodeIndex(), SourceInformation::toString);
        String tagDump = BytecodeNode.formatTagTree(errors, this.getTagTree(), s -> highlightedBci >= s.getEnterBytecodeIndex() && highlightedBci <= s.getReturnBytecodeIndex());
        String result = String.format("%s(name=%s)[\n    instructions(%s) = %s\n    exceptionHandlers(%s) = %s\n    locals(%s) = %s\n    sourceInformation(%s) = %s\n    tagTree%s\n]", this.getClass().getSimpleName(), ((RootNode)this.getParent()).getQualifiedName(), instructionCount, instructionsDump, exceptionCount, exceptionDump, localsCount, localsDump, sourceInfoCount, sourceDump, tagDump);
        if (!errors.isEmpty()) {
            IllegalStateException s2 = new IllegalStateException("Failed to dump. Individual errors are attached as suppressed errors. Incomplete dump: " + result);
            for (Throwable e2 : errors) {
                s2.addSuppressed(e2);
            }
            throw s2;
        }
        return result;
    }

    private static <T> String formatList(List<Throwable> errors, List<T> list, Predicate<T> highlight, Function<T, String> toString) {
        if (list == null) {
            return "Not Available";
        }
        if (list.isEmpty()) {
            return "Empty";
        }
        StringBuilder b = new StringBuilder();
        for (T o : list) {
            String v;
            if (highlight.test(o)) {
                b.append("\n    ==> ");
            } else {
                b.append("\n        ");
            }
            try {
                v = toString.apply(o);
            }
            catch (Throwable t) {
                v = t.toString();
                errors.add(t);
            }
            b.append(v);
        }
        return b.toString();
    }

    private static String formatTagTree(List<Throwable> errors, TagTree tree, Predicate<TagTree> highlight) {
        if (tree == null) {
            return " = Not Available";
        }
        int maxWidth = BytecodeNode.maxTagTreeWidth(0, tree);
        StringBuilder b = new StringBuilder();
        int count = BytecodeNode.appendTagTree(errors, b, 0, maxWidth, tree, highlight);
        b.insert(0, "(" + count + ") = ");
        return b.toString();
    }

    private static int maxTagTreeWidth(int indentation, TagTree tree) {
        int width = BytecodeNode.formatTagTreeLabel(indentation, tree, i -> false, tree).length();
        for (TagTree child : tree.getTreeChildren()) {
            width = Math.max(width, BytecodeNode.maxTagTreeWidth(indentation + 2, child));
        }
        return width;
    }

    private static int appendTagTree(List<Throwable> errors, StringBuilder sb, int indentation, int maxWidth, TagTree tree, Predicate<TagTree> highlight) {
        TagTreeNode node = (TagTreeNode)tree;
        sb.append("\n");
        try {
            String line = BytecodeNode.formatTagTreeLabel(indentation, tree, highlight, node);
            sb.append(line);
            int spaces = maxWidth - line.length();
            for (int i = 0; i < spaces; ++i) {
                sb.append(" ");
            }
            sb.append(" | ");
            SourceSection sourceSection = node.getSourceSection();
            if (sourceSection != null) {
                sb.append(SourceInformation.formatSourceSection(sourceSection, 60));
            }
        }
        catch (Throwable t) {
            sb.append(t.toString());
            errors.add(t);
        }
        int count = 1;
        for (TagTree child : tree.getTreeChildren()) {
            count += BytecodeNode.appendTagTree(errors, sb, indentation + 2, maxWidth, child, highlight);
        }
        return count;
    }

    private static String formatTagTreeLabel(int indentation, TagTree tree, Predicate<TagTree> highlight, TagTree node) {
        StringBuilder line = new StringBuilder();
        if (highlight.test(tree)) {
            line.append("    ==> ");
        } else {
            line.append("        ");
        }
        line.append("[");
        line.append(String.format("%04x", node.getEnterBytecodeIndex()));
        line.append(" .. ");
        line.append(String.format("%04x", node.getReturnBytecodeIndex()));
        line.append("] ");
        for (int i = 0; i < indentation; ++i) {
            line.append(" ");
        }
        line.append("(");
        line.append(((TagTreeNode)node).getTagsString());
        line.append(")");
        return line.toString();
    }

    protected abstract Instruction findInstruction(int var1);

    protected abstract int findBytecodeIndex(Frame var1, Node var2);

    protected abstract int findBytecodeIndex(FrameInstance var1);

    protected abstract int translateBytecodeIndex(BytecodeNode var1, int var2);

    protected abstract boolean validateBytecodeIndex(int var1);

    protected final BytecodeLocation findLocation(int bytecodeIndex) {
        return new BytecodeLocation(this, bytecodeIndex);
    }

    protected static final Object createDefaultStackTraceElement(TruffleStackTraceElement e) {
        return new DefaultBytecodeStackTraceElement(e);
    }

    public static Object[] getLocalValues(FrameInstance frameInstance) {
        BytecodeNode bytecode = BytecodeNode.get(frameInstance);
        if (bytecode == null) {
            return null;
        }
        Frame frame = BytecodeNode.resolveFrame(frameInstance);
        int bci = bytecode.findBytecodeIndexImpl(frame, frameInstance.getCallNode());
        return bytecode.getLocalValues(bci, frame);
    }

    public static Object[] getLocalNames(FrameInstance frameInstance) {
        BytecodeNode bytecode = BytecodeNode.get(frameInstance);
        if (bytecode == null) {
            return null;
        }
        int bci = bytecode.findBytecodeIndex(frameInstance);
        return bytecode.getLocalNames(bci);
    }

    public static boolean setLocalValues(FrameInstance frameInstance, Object[] values) {
        BytecodeNode bytecode = BytecodeNode.get(frameInstance);
        if (bytecode == null) {
            return false;
        }
        int bci = bytecode.findBytecodeIndex(frameInstance);
        bytecode.setLocalValues(bci, frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE), values);
        return true;
    }

    private static Frame resolveFrame(FrameInstance frameInstance) {
        RootCallTarget root;
        RootNode rootNode;
        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
        CallTarget callTarget = frameInstance.getCallTarget();
        if (callTarget instanceof RootCallTarget && (rootNode = (root = (RootCallTarget)callTarget).getRootNode()) instanceof ContinuationRootNode) {
            ContinuationRootNode continuation = (ContinuationRootNode)rootNode;
            frame = continuation.findFrame(frame);
        }
        return frame;
    }

    @CompilerDirectives.TruffleBoundary
    public static BytecodeNode get(FrameInstance frameInstance) {
        return BytecodeNode.get(frameInstance.getCallNode());
    }

    @ExplodeLoop
    public static BytecodeNode get(Node node) {
        Node location;
        for (Node currentNode = location = node; currentNode != null; currentNode = currentNode.getParent()) {
            if (!(currentNode instanceof BytecodeNode)) continue;
            BytecodeNode bytecodeNode = (BytecodeNode)currentNode;
            return bytecodeNode;
        }
        return null;
    }

    public static BytecodeNode get(TruffleStackTraceElement element) {
        Node location = element.getLocation();
        if (location == null) {
            return null;
        }
        return BytecodeNode.get(location);
    }
}

