/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.ExceptionHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.Instruction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.SourceInformation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameInstance;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@Bind.DefaultExpression(value="$bytecodeNode.getBytecodeLocation($bytecodeIndex)")
public final class BytecodeLocation {
    private final BytecodeNode bytecodes;
    private final int bytecodeIndex;

    BytecodeLocation(BytecodeNode bytecodes, int bytecodeIndex) {
        this.bytecodes = bytecodes;
        this.bytecodeIndex = bytecodeIndex;
        assert (bytecodes.validateBytecodeIndex(bytecodeIndex));
    }

    public int getBytecodeIndex() {
        return this.bytecodeIndex;
    }

    public BytecodeNode getBytecodeNode() {
        return this.bytecodes;
    }

    public int hashCode() {
        return Objects.hash(this.bytecodes, this.bytecodeIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BytecodeLocation) {
            BytecodeLocation other = (BytecodeLocation)obj;
            return this.bytecodes == other.bytecodes && this.bytecodeIndex == other.bytecodeIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("BytecodeLocation [bytecode=%s, bci=%d]", this.bytecodes, this.bytecodeIndex);
    }

    public String dump() {
        return this.bytecodes.dump(this);
    }

    public BytecodeLocation update() {
        BytecodeNode thisNode = this.bytecodes;
        BytecodeNode newNode = this.bytecodes.getBytecodeRootNode().getBytecodeNode();
        if (thisNode == newNode) {
            return this;
        }
        int newBytecodeIndex = thisNode.translateBytecodeIndex(newNode, this.bytecodeIndex);
        return new BytecodeLocation(newNode, newBytecodeIndex);
    }

    public BytecodeLocation ensureSourceInformation() {
        BytecodeNode thisNode = this.bytecodes.ensureSourceInformation();
        if (thisNode != this.bytecodes) {
            return this.update();
        }
        return this;
    }

    public SourceSection getSourceLocation() {
        return this.bytecodes.getSourceLocation(this.bytecodeIndex);
    }

    public SourceSection[] getSourceLocations() {
        return this.bytecodes.getSourceLocations(this.bytecodeIndex);
    }

    public Instruction getInstruction() {
        return this.bytecodes.findInstruction(this.bytecodeIndex);
    }

    public List<ExceptionHandler> getExceptionHandlers() {
        List<ExceptionHandler> handlers = this.bytecodes.getExceptionHandlers();
        ArrayList<ExceptionHandler> result = null;
        for (ExceptionHandler handler : handlers) {
            if (this.bytecodeIndex < handler.getStartBytecodeIndex() || this.bytecodeIndex >= handler.getEndBytecodeIndex()) continue;
            if (result == null) {
                result = new ArrayList<ExceptionHandler>();
            }
            result.add(handler);
        }
        return result == null ? List.of() : result;
    }

    public List<SourceInformation> getSourceInformation() {
        List<SourceInformation> sourceInfos = this.bytecodes.getSourceInformation();
        if (sourceInfos == null) {
            return null;
        }
        ArrayList<SourceInformation> found = null;
        for (SourceInformation info : sourceInfos) {
            if (this.bytecodeIndex < info.getStartBytecodeIndex() || this.bytecodeIndex >= info.getEndBytecodeIndex()) continue;
            if (found == null) {
                found = new ArrayList<SourceInformation>();
            }
            found.add(info);
        }
        return found == null ? List.of() : found;
    }

    @CompilerDirectives.TruffleBoundary
    public static BytecodeLocation get(FrameInstance frameInstance) {
        Node location = frameInstance.getCallNode();
        BytecodeNode foundBytecodeNode = null;
        for (Node current = location; current != null; current = current.getParent()) {
            BytecodeNode bytecodeNode;
            if (!(current instanceof BytecodeNode)) continue;
            foundBytecodeNode = bytecodeNode = (BytecodeNode)current;
            break;
        }
        if (foundBytecodeNode == null) {
            return null;
        }
        int bci = foundBytecodeNode.findBytecodeIndex(frameInstance);
        if (bci == -1) {
            return null;
        }
        return new BytecodeLocation(foundBytecodeNode, bci);
    }

    public static BytecodeLocation get(Node location, int bci) {
        Objects.requireNonNull(location);
        CompilerAsserts.partialEvaluationConstant(location);
        for (Node current = location; current != null; current = current.getParent()) {
            if (!(current instanceof BytecodeNode)) continue;
            BytecodeNode bytecodeNode = (BytecodeNode)current;
            return bytecodeNode.getBytecodeLocation(bci);
        }
        return null;
    }

    public static BytecodeLocation get(TruffleStackTraceElement element) {
        Node location = element.getLocation();
        if (location == null) {
            return null;
        }
        return BytecodeLocation.get(location, element.getBytecodeIndex());
    }
}

