/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode;

import java.lang.reflect.Field;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.bytecode.BytecodeDSLAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameExtensions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.memory.ByteArraySupport;
import sun.misc.Unsafe;

final class BytecodeDSLUncheckedAccess
extends BytecodeDSLAccess {
    static final Unsafe UNSAFE = BytecodeDSLUncheckedAccess.initUnsafe();

    BytecodeDSLUncheckedAccess() {
    }

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    @Override
    public FrameExtensions getFrameExtensions() {
        return BytecodeAccessor.RUNTIME.getFrameExtensionsUnsafe();
    }

    @Override
    public ByteArraySupport getByteArraySupport() {
        return BytecodeAccessor.MEMORY.getNativeUnsafe();
    }

    @Override
    public int readInt(int[] arr, int index) {
        assert (index >= 0 && index < arr.length);
        return UNSAFE.getInt(arr, Unsafe.ARRAY_INT_BASE_OFFSET + index * Unsafe.ARRAY_INT_INDEX_SCALE);
    }

    @Override
    public void writeInt(int[] arr, int index, int value) {
        assert (index >= 0 && index < arr.length);
        UNSAFE.putInt(arr, Unsafe.ARRAY_INT_BASE_OFFSET + index * Unsafe.ARRAY_INT_INDEX_SCALE, value);
    }

    @Override
    public <T> T readObject(T[] arr, int index) {
        assert (index >= 0 && index < arr.length);
        return (T)UNSAFE.getObject(arr, Unsafe.ARRAY_OBJECT_BASE_OFFSET + index * Unsafe.ARRAY_OBJECT_INDEX_SCALE);
    }

    @Override
    public <T> void writeObject(T[] arr, int index, T value) {
        assert (index >= 0 && index < arr.length);
        UNSAFE.putObject(arr, Unsafe.ARRAY_OBJECT_BASE_OFFSET + index * Unsafe.ARRAY_OBJECT_INDEX_SCALE, value);
    }

    @Override
    public <T> T uncheckedCast(Object obj, Class<T> clazz) {
        return (T)obj;
    }
}

