/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.language;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.ValueTranslatorObjectAdapter;

public class TypeScriptTypingsGenerator {
    public String generate() {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append("/**\n * Typings for Integrated Scripting.\n * This file is auto-generated on server start, so do not modify this file!\n */\n\ndeclare global {\n  var idContext: Context;\n}\n\nexport interface Context {\n  ops: Operations;\n}\n\n");
        fileBuilder.append("export interface Operations {\n");
        for (Map.Entry entry : Operators.REGISTRY.getGlobalInteractOperators().entrySet()) {
            this.handleOperator(fileBuilder, (String)entry.getKey(), (IOperator)entry.getValue(), false);
        }
        fileBuilder.append("}\n\n");
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            IValueTranslator translator = ValueTranslators.REGISTRY.getValueTypeTranslator(valueType);
            if (!valueType.isObject() || !(translator instanceof ValueTranslatorObjectAdapter)) continue;
            ValueTranslatorObjectAdapter translatorObjectAdapter = (ValueTranslatorObjectAdapter)translator;
            this.handleDescriptionComment(fileBuilder, valueType.getTranslationKey() + ".info");
            fileBuilder.append("export interface ");
            fileBuilder.append(this.getObjectValueTypeInterfaceName(valueType));
            fileBuilder.append(" {\n");
            fileBuilder.append("  ");
            fileBuilder.append(translatorObjectAdapter.getKey());
            fileBuilder.append(": Record<string, any>;\n\n");
            for (Map.Entry entry : ((Map)Operators.REGISTRY.getScopedInteractOperators().get(valueType)).entrySet()) {
                this.handleOperator(fileBuilder, (String)entry.getKey(), (IOperator)entry.getValue(), true);
            }
            fileBuilder.append("}\n\n");
        }
        return fileBuilder.toString();
    }

    private void handleDescriptionComment(StringBuilder sb, String unlocalizedKey) {
        if (MinecraftHelpers.isClientSide() && I18n.exists((String)unlocalizedKey)) {
            sb.append("  /**\n");
            sb.append("   * ");
            sb.append(L10NHelpers.localize((String)unlocalizedKey, (Object[])new Object[0]));
            sb.append("\n");
            sb.append("   */\n");
        }
    }

    private void handleOperator(StringBuilder sb, String name, IOperator operator, boolean scoped) {
        this.handleDescriptionComment(sb, operator.getTranslationKey() + ".info");
        sb.append(String.format("  %s: (%s) => %s;\n", name, this.generateArguments(operator, scoped), this.generateType(operator.getOutputType())));
    }

    private String generateArguments(IOperator operator, boolean scoped) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        IValueType[] inputTypes = operator.getInputTypes();
        if (scoped) {
            inputTypes = Arrays.copyOfRange(inputTypes, 1, inputTypes.length);
        }
        for (IValueType inputType : inputTypes) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("arg%s: %s", i++, this.generateType(inputType)));
        }
        return sb.toString();
    }

    private String generateType(IValueType<?> valueType) {
        if (ValueTypes.CATEGORY_NUMBER.correspondsTo(valueType)) {
            return "number";
        }
        if (valueType.isCategory()) {
            return "any";
        }
        if (ValueTypes.BOOLEAN == valueType) {
            return "boolean";
        }
        if (ValueTypes.STRING == valueType) {
            return "string";
        }
        if (ValueTypes.LIST == valueType) {
            return "any[]";
        }
        if (ValueTypes.NBT == valueType) {
            return "Record<string, any>";
        }
        if (ValueTypes.OPERATOR == valueType) {
            return "Function";
        }
        return this.getObjectValueTypeInterfaceName(valueType);
    }

    private String getObjectValueTypeInterfaceName(IValueType<?> valueType) {
        String name = valueType.getTypeName();
        return "Value" + Character.toTitleCase(name.charAt(0)) + name.substring(1);
    }
}

