/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.language;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integratedscripting.IntegratedScripting;
import org.cyclops.integratedscripting.api.language.ILanguageHandler;
import org.cyclops.integratedscripting.api.network.IScriptFactory;
import org.cyclops.integratedscripting.client.gui.image.ScriptImages;
import org.cyclops.integratedscripting.core.language.TypeScriptTypingsGenerator;
import org.cyclops.integratedscripting.core.network.GraalScriptFactory;

public class LanguageHandlerJavaScript
implements ILanguageHandler {
    public static final Style ATTRIBUTE = Style.EMPTY.withColor(TextColor.fromRgb((int)Helpers.RGBToInt((int)121, (int)93, (int)163)));
    public static final Style COMMENT = Style.EMPTY.withColor(TextColor.fromRgb((int)Helpers.RGBToInt((int)150, (int)152, (int)150)));
    public static final Style SYMBOL = Style.EMPTY.withColor(TextColor.fromRgb((int)Helpers.RGBToInt((int)99, (int)163, (int)92)));
    public static final Style CONSTANT = Style.EMPTY.withColor(TextColor.fromRgb((int)Helpers.RGBToInt((int)0, (int)134, (int)179)));
    public static final Style KEYWORD = Style.EMPTY.withColor(TextColor.fromRgb((int)Helpers.RGBToInt((int)167, (int)29, (int)93)));
    public final Map<String, Style> tokenStyles = Maps.newHashMap();
    private final IScriptFactory scriptFactory;

    public LanguageHandlerJavaScript() {
        this.tokenStyles.put("const", KEYWORD);
        this.tokenStyles.put("delete", KEYWORD);
        this.tokenStyles.put("let", KEYWORD);
        this.tokenStyles.put("var", KEYWORD);
        this.tokenStyles.put("function", KEYWORD);
        this.tokenStyles.put("return", KEYWORD);
        this.tokenStyles.put("true", KEYWORD);
        this.tokenStyles.put("false", KEYWORD);
        this.tokenStyles.put("{", SYMBOL);
        this.tokenStyles.put("}", SYMBOL);
        this.tokenStyles.put("(", SYMBOL);
        this.tokenStyles.put(")", SYMBOL);
        this.tokenStyles.put("[", SYMBOL);
        this.tokenStyles.put("]", SYMBOL);
        this.tokenStyles.put(".", SYMBOL);
        this.tokenStyles.put(";", SYMBOL);
        this.tokenStyles.put("=", SYMBOL);
        this.scriptFactory = new GraalScriptFactory("js");
    }

    @Override
    public String getName() {
        return "JavaScript";
    }

    @Override
    public IImage getIcon() {
        return ScriptImages.FILE_JS;
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.stream(new String[]{"js", "cjs", "mjs"}).toList();
    }

    @Override
    public List<Pair<Style, String>> markupLine(String line) {
        ArrayList segments = Lists.newArrayList();
        segments.add(Pair.of((Object)Style.EMPTY, (Object)line));
        for (Map.Entry<String, Style> entry : this.tokenStyles.entrySet()) {
            String token = entry.getKey();
            Style tokenStyle = entry.getValue();
            ArrayList segmentsNew = Lists.newArrayList();
            for (Pair segment : segments) {
                int pos;
                Style styleOriginal = (Style)segment.getLeft();
                String hayStack = (String)segment.getRight();
                while ((pos = hayStack.indexOf(token)) >= 0) {
                    segmentsNew.add(Pair.of((Object)styleOriginal, (Object)hayStack.substring(0, pos)));
                    segmentsNew.add(Pair.of((Object)tokenStyle, (Object)hayStack.substring(pos, pos + token.length())));
                    hayStack = hayStack.substring(pos + token.length());
                }
                segmentsNew.add(Pair.of((Object)styleOriginal, (Object)hayStack));
            }
            segments = segmentsNew;
        }
        return segments;
    }

    @Override
    public IScriptFactory getScriptFactory() throws EvaluationException {
        return this.scriptFactory;
    }

    @Override
    public void onServerStarted() {
        this.generateTypeScriptTypes();
    }

    private void generateTypeScriptTypes() {
        Path path = IntegratedScripting._instance.scriptingData.getRootPath().resolve("integratedscripting.d.ts");
        try {
            FileUtils.write((File)path.toFile(), (CharSequence)new TypeScriptTypingsGenerator().generate(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

