/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.InternalResourceRoots;
import com.oracle.truffle.polyglot.JDKSupport;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.InternalResource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.provider.InternalResourceProvider;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Pair;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;

final class InternalResourceCache {
    private static final char[] FILE_SYSTEM_SPECIAL_CHARACTERS = new char[]{'/', '\\', ':'};
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>> optionalInternalResourcesCaches = new HashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>>();
    private static final Map<String, Map<String, Supplier<InternalResourceCache>>> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static final boolean useInternalResources = Boolean.TRUE;
    private static boolean useExternalDirectoryInNativeImage = true;
    private final String id;
    private final String resourceId;
    private final Supplier<InternalResource> resourceFactory;
    private boolean requiresEagerUnpack;
    private InternalResourceRoots.Root owningRoot;
    private volatile Path path;
    private Path aggregatedFileListResource;
    private String aggregatedFileListHash;

    InternalResourceCache(String languageId, String resourceId, Supplier<InternalResource> resourceFactory) {
        this.id = Objects.requireNonNull(languageId);
        this.resourceId = Objects.requireNonNull(resourceId);
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
    }

    String getResourceId() {
        return this.resourceId;
    }

    Path getPathOrNull() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path getPath(PolyglotEngineImpl polyglotEngine) throws IOException {
        if (InternalResourceCache.usesInternalResources()) {
            Path result = this.path;
            if (result == null) {
                InternalResourceCache internalResourceCache = this;
                synchronized (internalResourceCache) {
                    result = this.path;
                    if (result == null) {
                        this.path = result = this.installResource(resource -> EngineAccessor.LANGUAGE.createInternalResourceEnv((InternalResource)resource, () -> polyglotEngine.inEnginePreInitialization));
                    }
                }
            }
            if (polyglotEngine.inEnginePreInitialization) {
                this.requiresEagerUnpack = true;
            }
            return result;
        }
        throw new IllegalArgumentException("Internal resources are restricted. To enable them, use '-H:+CopyLanguageResources' during the native image build.");
    }

    void initializeOwningRoot(InternalResourceRoots.Root root) {
        assert (this.owningRoot == null);
        assert (this.path == null);
        this.owningRoot = root;
        switch (root.kind()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RESOURCE: {
                Path path = root.path();
                break;
            }
            case COMPONENT: {
                Path path = root.path().resolve(InternalResourceCache.sanitize(this.resourceId));
                break;
            }
            case UNVERSIONED: {
                Path path = this.findStandaloneResourceRoot(root.path());
                break;
            }
            case VERSIONED: {
                Path path = this.path = null;
            }
        }
        if (this.path != null && InternalResourceRoots.isTraceInternalResourceEvents()) {
            String hint = switch (root.kind()) {
                case InternalResourceRoots.Root.Kind.RESOURCE -> InternalResourceRoots.overriddenResourceRootProperty(this.id, this.resourceId) + " system property";
                case InternalResourceRoots.Root.Kind.COMPONENT -> InternalResourceRoots.overriddenComponentRootProperty(this.id) + " system property";
                case InternalResourceRoots.Root.Kind.UNVERSIONED -> "internal resource cache root directory";
                default -> throw CompilerDirectives.shouldNotReachHere(root.kind().name());
            };
            InternalResourceRoots.logInternalResourceEvent("Resolved a pre-created directory for the internal resource %s::%s to: %s, determined by the %s with the value %s.", this.id, this.resourceId, this.path, hint, root.path());
        }
    }

    void clearCache() {
        this.owningRoot = null;
        this.path = null;
    }

    boolean requiresEagerUnpack() {
        return this.requiresEagerUnpack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path installRuntimeResource(InternalResource resource) throws IOException {
        InternalResourceCache cache;
        InternalResourceCache internalResourceCache = cache = InternalResourceCache.createRuntimeResourceCache(resource);
        synchronized (internalResourceCache) {
            Path result = cache.path;
            if (result == null) {
                cache.path = result = cache.installResource(InternalResourceCache::createInternalResourceEnvReflectively);
            }
            return result;
        }
    }

    private static InternalResourceCache createRuntimeResourceCache(InternalResource resource) {
        InternalResource.Id id = resource.getClass().getAnnotation(InternalResource.Id.class);
        assert (id != null) : String.valueOf(resource.getClass()) + " must be annotated by @InternalResource.Id";
        InternalResourceCache cache = new InternalResourceCache("engine", id.value(), () -> resource);
        InternalResourceRoots.initializeRuntimeResource(cache);
        return cache;
    }

    private static InternalResource.Env createInternalResourceEnvReflectively(InternalResource resource) {
        try {
            Constructor newEnv = InternalResource.Env.class.getDeclaredConstructor(InternalResource.class, BooleanSupplier.class);
            newEnv.setAccessible(true);
            return (InternalResource.Env)newEnv.newInstance(resource, () -> TruffleOptions.AOT);
        }
        catch (ReflectiveOperationException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    private Path installResource(Function<InternalResource, InternalResource.Env> resourceEnvProvider) throws IOException {
        String versionHash;
        Objects.requireNonNull(resourceEnvProvider, "ResourceEnvProvider must be non-null.");
        assert (Thread.holdsLock(this)) : "Unpacking must be called under lock";
        assert (this.owningRoot.kind() == InternalResourceRoots.Root.Kind.VERSIONED);
        assert (!ImageInfo.inImageRuntimeCode() || this.aggregatedFileListHash != null) : "InternalResource#unpackFiles must not be called in the image execution time.";
        InternalResource resource = this.resourceFactory.get();
        InternalResource.Env env = resourceEnvProvider.apply(resource);
        String string = versionHash = this.aggregatedFileListHash == null || env.inNativeImageBuild() ? resource.versionHash(env) : this.aggregatedFileListHash;
        if (versionHash.getBytes().length > 128) {
            throw new IOException("The version hash length is restricted to a maximum of 128 bytes.");
        }
        Path target = this.owningRoot.path().resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId), InternalResourceCache.sanitize(versionHash)));
        if (!Files.exists(target, new LinkOption[0])) {
            InternalResourceRoots.logInternalResourceEvent("Resolved a directory for the internal resource %s::%s to: %s, unpacking resource files.", this.id, this.resourceId, target);
            Path parent = target.getParent();
            if (parent == null) {
                throw CompilerDirectives.shouldNotReachHere("Target must have a parent directory but was " + String.valueOf(target));
            }
            Path owner = Files.createDirectories(Objects.requireNonNull(parent), new FileAttribute[0]);
            Path tmpDir = Files.createTempDirectory(owner, null, new FileAttribute[0]);
            if (this.aggregatedFileListResource == null || env.inNativeImageBuild()) {
                resource.unpackFiles(env, tmpDir);
            } else {
                env.unpackResourceFiles(this.aggregatedFileListResource, tmpDir, Path.of("META-INF", "resources", InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId)));
            }
            try {
                Files.move(tmpDir, target, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (FileAlreadyExistsException existsException) {
                InternalResourceCache.unlink(tmpDir);
            }
            catch (FileSystemException fsException) {
                if (Files.isDirectory(target, new LinkOption[0])) {
                    InternalResourceCache.unlink(tmpDir);
                }
            }
        } else {
            InternalResourceRoots.logInternalResourceEvent("Resolved a directory for the internal resource %s::%s to: %s, using existing resource files.", this.id, this.resourceId, target);
            InternalResourceCache.verifyResourceRoot(target);
        }
        return target;
    }

    private static void verifyResourceRoot(Path resourceRoot) throws IOException {
        if (!Files.isDirectory(resourceRoot, new LinkOption[0])) {
            throw new IOException("Resource cache root " + String.valueOf(resourceRoot) + " must be a directory.");
        }
        if (!Files.isReadable(resourceRoot)) {
            throw new IOException("Resource cache root " + String.valueOf(resourceRoot) + " must be readable.");
        }
    }

    private Path findStandaloneResourceRoot(Path root) {
        return root.resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId)));
    }

    private static String sanitize(String pathElement) {
        String result = pathElement;
        for (char fileSystemsSpecialChar : FILE_SYSTEM_SPECIAL_CHARACTERS) {
            result = result.replace(fileSystemsSpecialChar, '_');
        }
        return result;
    }

    public static boolean usesInternalResources() {
        return useInternalResources;
    }

    public static boolean usesResourceDirectoryOnNativeImage() {
        return useExternalDirectoryInNativeImage;
    }

    static void initializeNativeImageState(ClassLoader nativeImageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(InternalResourceCache.collectOptionalResources(List.of(new EngineAccessor.StrongClassLoaderSupplier(nativeImageClassLoader))));
    }

    static void resetNativeImageState() {
        nativeImageCache.clear();
    }

    static boolean copyResourcesForNativeImage(Path target, String ... components) throws IOException {
        HashSet<String> componentFilter;
        boolean[] result = new boolean[]{false};
        if (components.length != 0) {
            componentFilter = new HashSet<String>();
            componentFilter.add("engine");
            HashSet requiredComponentIds = new HashSet();
            Collections.addAll(requiredComponentIds, components);
            HashSet<String> requiredLanguageIds = new HashSet<String>(LanguageCache.languages().keySet());
            requiredLanguageIds.retainAll(requiredComponentIds);
            Set requiredInstrumentIds = InstrumentCache.load().stream().map(InstrumentCache::getId).collect(Collectors.toSet());
            requiredInstrumentIds.retainAll(requiredComponentIds);
            requiredComponentIds.removeAll(requiredLanguageIds);
            requiredComponentIds.removeAll(requiredInstrumentIds);
            if (!requiredComponentIds.isEmpty()) {
                TreeSet<String> installedComponents = new TreeSet<String>(LanguageCache.languages().keySet());
                InstrumentCache.load().stream().map(InstrumentCache::getId).forEach(installedComponents::add);
                throw new IllegalArgumentException(String.format("Components with ids %s are not installed. Installed components are: %s.", String.join((CharSequence)", ", requiredComponentIds), String.join((CharSequence)", ", installedComponents)));
            }
            HashSet<LanguageCache> requiredLanguages = new HashSet<LanguageCache>(LanguageCache.internalLanguages());
            for (String requiredLanguageId : requiredLanguageIds) {
                requiredLanguages.addAll(LanguageCache.computeTransitiveLanguageDependencies(requiredLanguageId));
            }
            requiredLanguages.stream().map(LanguageCache::getId).forEach(componentFilter::add);
            InstrumentCache.internalInstruments().stream().map(InstrumentCache::getId).forEach(componentFilter::add);
            componentFilter.addAll(requiredInstrumentIds);
        } else {
            componentFilter = null;
        }
        InternalResourceCache.walkAllResources((componentId, resources) -> {
            if (componentFilter == null || componentFilter.contains(componentId)) {
                for (InternalResourceCache cache : resources) {
                    result[0] = result[0] | cache.copyResourcesForNativeImage(target);
                }
            }
        });
        return result[0];
    }

    private boolean copyResourcesForNativeImage(Path target) throws IOException {
        if (this.isMissingOptionalResource()) {
            return false;
        }
        Path root = this.findStandaloneResourceRoot(target);
        InternalResourceCache.unlink(root);
        Files.createDirectories(root, new FileAttribute[0]);
        InternalResource resource = this.resourceFactory.get();
        InternalResource.Env env = EngineAccessor.LANGUAGE.createInternalResourceEnv(resource, () -> false);
        resource.unpackFiles(env, root);
        if (InternalResourceCache.isEmpty(root)) {
            Files.deleteIfExists(root);
            return false;
        }
        return true;
    }

    private boolean isMissingOptionalResource() {
        return this.path == null && this.resourceFactory instanceof NonExistingResourceSupplier;
    }

    static void includeResourcesForNativeImage(Path tempDir, BiConsumer<Module, Pair<String, byte[]>> resourceLocationConsumer) throws Exception {
        InternalResourceCache.walkAllResources((componentId, resources) -> {
            for (InternalResourceCache cache : resources) {
                cache.includeResourcesForNativeImageImpl(tempDir, resourceLocationConsumer);
            }
        });
        useExternalDirectoryInNativeImage = false;
    }

    private static String getResourceName(Path path) {
        return path.toString().replace(File.separatorChar, '/');
    }

    static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private void includeResourcesForNativeImageImpl(Path tempDir, BiConsumer<Module, Pair<String, byte[]>> resourceLocationConsumer) throws IOException, NoSuchAlgorithmException {
        if (this.isMissingOptionalResource()) {
            return;
        }
        Path root = this.findStandaloneResourceRoot(tempDir);
        InternalResourceCache.unlink(root);
        Files.createDirectories(root, new FileAttribute[0]);
        InternalResource resource = this.resourceFactory.get();
        InternalResource.Env env = EngineAccessor.LANGUAGE.createInternalResourceEnv(resource, () -> false);
        resource.unpackFiles(env, root);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        StringBuilder fileList = new StringBuilder();
        try (Stream<Path> filesToRead = Files.walk(root, new FileVisitOption[0]);){
            for (Path f : filesToRead.sorted().toList()) {
                if (Files.isDirectory(f, new LinkOption[0])) continue;
                String resourceName = InternalResourceCache.getResourceName(Path.of("META-INF", "resources").resolve(tempDir.relativize(f)));
                byte[] resourceBytes = Files.readAllBytes(f);
                digest.update(resourceBytes);
                resourceLocationConsumer.accept(resource.getClass().getModule(), Pair.create(resourceName, resourceBytes));
                String fileListEntry = resourceName + "=" + (env.getOS() != InternalResource.OS.WINDOWS ? PosixFilePermissions.toString(Files.getPosixFilePermissions(f, new LinkOption[0])) : PosixFilePermissions.toString(Collections.emptySet()));
                fileList.append(fileListEntry).append(System.lineSeparator());
            }
        }
        byte[] fileListBytes = fileList.toString().getBytes(StandardCharsets.UTF_8);
        byte[] encodedHash = digest.digest(fileListBytes);
        this.aggregatedFileListHash = InternalResourceCache.bytesToHex(encodedHash);
        this.aggregatedFileListResource = Path.of("META-INF", "resources").resolve(tempDir.relativize(root)).resolve("filelist." + this.aggregatedFileListHash);
        resourceLocationConsumer.accept(resource.getClass().getModule(), Pair.create(InternalResourceCache.getResourceName(this.aggregatedFileListResource), fileList.toString().getBytes()));
    }

    static <T extends Throwable> void walkAllResources(ResourcesVisitor<T> consumer) throws T {
        Collection<InternalResourceCache> resources;
        for (LanguageCache language : LanguageCache.languages().values()) {
            resources = language.getResources();
            if (resources.isEmpty()) continue;
            consumer.visit(language.getId(), language.getResources());
        }
        for (InstrumentCache instrument : InstrumentCache.load()) {
            resources = instrument.getResources();
            if (resources.isEmpty()) continue;
            consumer.visit(instrument.getId(), resources);
        }
        Collection<InternalResourceCache> engineResources = InternalResourceCache.getEngineResources();
        if (!engineResources.isEmpty()) {
            consumer.visit("engine", engineResources);
        }
    }

    static Collection<String> getEngineResourceIds() {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        return engineResources != null ? engineResources.keySet() : List.of();
    }

    static Collection<InternalResourceCache> getEngineResources() {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        if (engineResources != null) {
            return engineResources.values().stream().map(Supplier::get).collect(Collectors.toList());
        }
        return List.of();
    }

    static InternalResourceCache getEngineResource(String resourceId) {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        Supplier<InternalResourceCache> resourceSupplier = engineResources != null ? engineResources.get(resourceId) : null;
        return resourceSupplier != null ? resourceSupplier.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Map<String, Supplier<InternalResourceCache>>> loadOptionalInternalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        if (TruffleOptions.AOT) {
            assert (nativeImageCache != null);
            return nativeImageCache;
        }
        Class<InternalResourceCache> clazz = InternalResourceCache.class;
        synchronized (InternalResourceCache.class) {
            Map<String, Map<String, Supplier<InternalResourceCache>>> cache = optionalInternalResourcesCaches.get(suppliers);
            if (cache == null) {
                cache = InternalResourceCache.collectOptionalResources(suppliers);
                optionalInternalResourcesCaches.put(suppliers, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, Map<String, Supplier<InternalResourceCache>>> collectOptionalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        HashMap<String, Map<String, Supplier<InternalResourceCache>>> cache = new HashMap<String, Map<String, Supplier<InternalResourceCache>>>();
        for (EngineAccessor.AbstractClassLoaderSupplier supplier : suppliers) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            StreamSupport.stream(ServiceLoader.load(InternalResourceProvider.class, loader).spliterator(), false).filter(p -> supplier.accepts(p.getClass())).forEach(p -> {
                JDKSupport.exportTransitivelyTo(p.getClass().getModule());
                String componentId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId((InternalResourceProvider)p);
                String resourceId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId((InternalResourceProvider)p);
                Map componentOptionalResources = cache.computeIfAbsent(componentId, k -> new HashMap());
                OptionalResourceSupplier resourceSupplier = new OptionalResourceSupplier((InternalResourceProvider)p);
                OptionalResourceSupplier existing = componentOptionalResources.put(resourceId, resourceSupplier);
                if (existing != null && !InternalResourceCache.hasSameCodeSource(resourceSupplier, existing)) {
                    throw InternalResourceCache.throwDuplicateOptionalResourceException(existing.get(), resourceSupplier.get());
                }
            });
        }
        return cache;
    }

    private static boolean hasSameCodeSource(OptionalResourceSupplier first, OptionalResourceSupplier second) {
        return first.optionalResourceProvider.getClass() == second.optionalResourceProvider.getClass();
    }

    static RuntimeException throwDuplicateOptionalResourceException(InternalResourceCache existing, InternalResourceCache duplicate) {
        String message = String.format("Duplicate optional resource id %s for component %s. First optional resource [%s]. Second optional resource [%s].", existing.resourceId, existing.id, InternalResourceCache.formatResourceLocation(existing.resourceFactory.get()), InternalResourceCache.formatResourceLocation(duplicate.resourceFactory.get()));
        throw new IllegalStateException(message);
    }

    private static String formatResourceLocation(InternalResource internalResource) {
        URL url;
        StringBuilder sb = new StringBuilder();
        sb.append("Internal resource class ").append(internalResource.getClass().getName());
        CodeSource source = internalResource.getClass().getProtectionDomain().getCodeSource();
        URL uRL = url = source != null ? source.getLocation() : null;
        if (url != null) {
            sb.append(", Loaded from ").append(url);
        }
        return sb.toString();
    }

    private static boolean isEmpty(Path folder) throws IOException {
        try (Stream<Path> children = Files.list(folder);){
            boolean bl = children.findAny().isEmpty();
            return bl;
        }
    }

    private static void unlink(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
                for (Path child : children) {
                    InternalResourceCache.unlink(child);
                }
            }
        }
        Files.deleteIfExists(path);
    }

    public String toString() {
        return "InternalResourceCache[componentId='" + this.id + "', resourceId='" + this.resourceId + "', resourceRoot=" + String.valueOf(this.path) + "}";
    }

    static Supplier<InternalResource> nonExistingResource(String component, String resource) {
        return new NonExistingResourceSupplier(component, resource);
    }

    @FunctionalInterface
    static interface ResourcesVisitor<T extends Throwable> {
        public void visit(String var1, Collection<InternalResourceCache> var2) throws T;
    }

    private record NonExistingResourceSupplier(String component, String resource) implements Supplier<InternalResource>
    {
        @Override
        public InternalResource get() {
            throw new IllegalStateException(String.format("Optional resource '%s' for component '%s' is missing. Use `-Dpolyglot.engine.resourcePath.%s.%s=<path>` to configure a path to the internal resource root or include resource jar file to the module-path.", this.resource, this.component, this.component, this.resource));
        }
    }

    private static final class OptionalResourceSupplier
    implements Supplier<InternalResourceCache> {
        private final InternalResourceProvider optionalResourceProvider;
        private volatile InternalResourceCache cachedResource;

        private OptionalResourceSupplier(InternalResourceProvider optionalResourceProvider) {
            Objects.requireNonNull(optionalResourceProvider, "OptionalResourceProvider must be non null");
            this.optionalResourceProvider = optionalResourceProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InternalResourceCache get() {
            InternalResourceCache res = this.cachedResource;
            if (res == null) {
                OptionalResourceSupplier optionalResourceSupplier = this;
                synchronized (optionalResourceSupplier) {
                    res = this.cachedResource;
                    if (res == null) {
                        this.cachedResource = res = new InternalResourceCache(EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId(this.optionalResourceProvider), EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId(this.optionalResourceProvider), () -> EngineAccessor.LANGUAGE_PROVIDER.createInternalResource(this.optionalResourceProvider));
                    }
                }
            }
            return res;
        }
    }
}

