/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.home;

import java.util.Arrays;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.org.graalvm.home.HomeFinder;

public final class Version
implements Comparable<Version> {
    private static final String SNAPSHOT_STRING = "snapshot";
    private static final String SNAPSHOT_SUFFIX = "dev";
    private static final int MIN_VERSION_DIGITS = 3;
    private final int[] versions;
    private final String suffix;
    private final boolean snapshot;

    Version(int ... versions) {
        this.versions = versions;
        this.suffix = null;
        this.snapshot = false;
    }

    Version(String v2) {
        if (v2.equals(SNAPSHOT_STRING) || v2.equals(SNAPSHOT_SUFFIX)) {
            this.snapshot = true;
            this.versions = new int[0];
            this.suffix = SNAPSHOT_STRING;
        } else {
            int end;
            int dash = v2.indexOf(45);
            if (dash != -1) {
                this.suffix = v2.substring(dash + 1, v2.length());
                this.snapshot = this.suffix.equals(SNAPSHOT_SUFFIX);
                end = dash;
            } else {
                this.suffix = null;
                this.snapshot = false;
                end = v2.length();
            }
            String versionsString = v2.substring(0, end);
            String[] versionChunks = versionsString.split("\\.", -1);
            int[] intVersions = new int[versionChunks.length];
            for (int i2 = 0; i2 < versionChunks.length; ++i2) {
                try {
                    intVersions[i2] = Integer.parseInt(versionChunks[i2]);
                }
                catch (NumberFormatException f2) {
                    throw Version.invalid(v2);
                }
                assert (intVersions[i2] >= 0);
            }
            if ((intVersions = Version.trimTrailingZeros(intVersions)).length == 0) {
                throw Version.invalid(v2);
            }
            this.versions = intVersions;
        }
    }

    private static int[] trimTrailingZeros(int[] intVersions) {
        int trimVersions;
        for (trimVersions = intVersions.length - 1; trimVersions >= 0 && intVersions[trimVersions] == 0; --trimVersions) {
        }
        if (trimVersions != intVersions.length - 1) {
            return Arrays.copyOf(intVersions, trimVersions + 1);
        }
        return intVersions;
    }

    private static IllegalArgumentException invalid(String v2) {
        return new IllegalArgumentException("Invalid version string '" + v2 + "'.");
    }

    public boolean isRelease() {
        return !this.snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public int compareTo(Version o2) {
        int[] thisVersions = this.versions;
        int[] otherVersions = o2.versions;
        for (int i2 = 0; i2 < Math.max(otherVersions.length, thisVersions.length); ++i2) {
            int otherVersion;
            int version = i2 >= thisVersions.length ? 0 : thisVersions[i2];
            int cmp = Integer.compare(version, otherVersion = i2 >= otherVersions.length ? 0 : otherVersions[i2]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compareTo(int ... compareVersions) {
        return this.compareTo(Version.create(compareVersions));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return Arrays.equals(this.versions, other.versions) && this.snapshot == other.snapshot && Objects.equals(this.suffix, other.suffix);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.versions), this.snapshot, this.suffix);
    }

    public String toString() {
        if (this.versions.length == 0) {
            assert (this.suffix != null && this.suffix.equals(SNAPSHOT_STRING));
            return this.suffix;
        }
        StringBuilder b2 = new StringBuilder();
        String sep = "";
        for (int i2 = 0; i2 < Math.max(3, this.versions.length); ++i2) {
            b2.append(sep);
            if (i2 < this.versions.length) {
                b2.append(this.versions[i2]);
            } else {
                b2.append(0);
            }
            sep = ".";
        }
        if (this.suffix != null) {
            b2.append("-").append(this.suffix);
        }
        return b2.toString();
    }

    private String processFormat(String format) {
        StringBuilder ret = new StringBuilder(format.length());
        int idx = 0;
        while (idx < format.length()) {
            char ch;
            if ((ch = format.charAt(idx++)) == '%') {
                if ((ch = format.charAt(idx++)) == '[') {
                    ch = format.charAt(idx++);
                    boolean include = false;
                    switch (ch) {
                        case 'R': {
                            include = this.isRelease();
                            break;
                        }
                        case 'S': {
                            include = this.isSnapshot();
                            break;
                        }
                        default: {
                            if ('0' > ch || ch > '9') break;
                            int num = ch - 48;
                            include = this.versions.length >= num;
                        }
                    }
                    int start = idx;
                    idx = format.indexOf(93, start);
                    if (idx < 0) {
                        idx = format.length();
                    }
                    if (include) {
                        ret.append(format.substring(start, idx));
                    }
                    ++idx;
                    continue;
                }
                ret.append('%');
                ret.append(ch);
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    public String format(String format) {
        int len = this.versions.length;
        if (len < 4) {
            len = 4;
        }
        Object[] args = new Object[len];
        int i2 = 0;
        for (int v2 : this.versions) {
            args[i2++] = v2;
        }
        while (i2 < len) {
            args[i2] = 0;
            ++i2;
        }
        return String.format(this.processFormat(format), args);
    }

    public static Version parse(String versionString) throws IllegalArgumentException {
        Objects.requireNonNull(versionString);
        return new Version(versionString);
    }

    public static Version create(int ... versions) throws IllegalArgumentException {
        Objects.requireNonNull(versions);
        int[] useVersions = Version.trimTrailingZeros(versions);
        if (useVersions.length == 0) {
            throw new IllegalArgumentException("At least one non-zero version must be specified.");
        }
        for (int i2 = 0; i2 < useVersions.length; ++i2) {
            if (useVersions[i2] >= 0) continue;
            throw new IllegalArgumentException("Versions must not be negative.");
        }
        return new Version(useVersions);
    }

    public static Version getCurrent() {
        return Version.parse(HomeFinder.getInstance().getVersion());
    }
}

