/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.DynamicThresholdsQueue;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.TraversingBlockingQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class BackgroundCompileQueue {
    protected final OptimizedTruffleRuntime runtime;
    private final AtomicLong idCounter;
    private volatile ThreadPoolExecutor compilationExecutorService;
    private volatile BlockingQueue<Runnable> compilationQueue;
    private boolean shutdown = false;
    private long delayMillis;

    public BackgroundCompileQueue(OptimizedTruffleRuntime runtime) {
        this.runtime = runtime;
        this.idCounter = new AtomicLong();
    }

    private static int log2(int n2) {
        assert (n2 > 0);
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(OptimizedCallTarget callTarget) {
        ThreadPoolExecutor service = this.compilationExecutorService;
        if (service != null) {
            return service;
        }
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            service = this.compilationExecutorService;
            if (service != null) {
                return service;
            }
            if (this.shutdown) {
                throw new RejectedExecutionException("The BackgroundCompileQueue is shutdown");
            }
            this.delayMillis = callTarget.getOptionValue(OptimizedRuntimeOptions.EncodedGraphCachePurgeDelay).intValue();
            int threads = callTarget.getOptionValue(OptimizedRuntimeOptions.CompilerThreads);
            if (threads == 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                if (availableProcessors >= 4) {
                    threads = 2;
                }
            } else if (threads < 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                int logCPU = BackgroundCompileQueue.log2(availableProcessors);
                int loglogCPU = BackgroundCompileQueue.log2(Math.max(logCPU, 1));
                threads = Math.min(availableProcessors / 4 + loglogCPU, 16);
            }
            threads = Math.max(1, threads);
            ThreadFactory factory = this.newThreadFactory("TruffleCompilerThread", callTarget);
            long compilerIdleDelay = this.runtime.getCompilerIdleDelay(callTarget);
            long keepAliveTime = compilerIdleDelay >= 0L ? compilerIdleDelay : 0L;
            this.compilationQueue = this.createQueue(callTarget, threads);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threads, threads, keepAliveTime, TimeUnit.MILLISECONDS, this.compilationQueue, factory){

                @Override
                protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                    return new CompilationTask.ExecutorServiceWrapper((CompilationTask)callable);
                }
            };
            if (compilerIdleDelay > 0L) {
                threadPoolExecutor.allowCoreThreadTimeOut(true);
            }
            this.compilationExecutorService = threadPoolExecutor;
            return this.compilationExecutorService;
        }
    }

    private BlockingQueue<Runnable> createQueue(OptimizedCallTarget callTarget, int threads) {
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraversingCompilationQueue).booleanValue()) {
            if (callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholds).booleanValue() && callTarget.getOptionValue(OptimizedRuntimeOptions.BackgroundCompilation).booleanValue()) {
                double minScale = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinScale);
                int minNormalLoad = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinNormalLoad);
                int maxNormalLoad = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMaxNormalLoad);
                return new DynamicThresholdsQueue(threads, minScale, minNormalLoad, maxNormalLoad, new IdlingLinkedBlockingDeque<Runnable>());
            }
            return new TraversingBlockingQueue(new IdlingLinkedBlockingDeque<Runnable>());
        }
        return new IdlingPriorityBlockingQueue<Runnable>();
    }

    protected ThreadFactory newThreadFactory(String threadNamePrefix, OptimizedCallTarget callTarget) {
        return new TruffleCompilerThreadFactory(threadNamePrefix, this.runtime);
    }

    private CompilationTask submitTask(CompilationTask compilationTask) {
        compilationTask.setFuture(this.getExecutorService((OptimizedCallTarget)compilationTask.targetRef.get()).submit(compilationTask));
        return compilationTask;
    }

    public CompilationTask submitCompilation(Priority priority, OptimizedCallTarget target) {
        WeakReference<OptimizedCallTarget> targetReference = new WeakReference<OptimizedCallTarget>(target);
        CompilationTask compilationTask = CompilationTask.createCompilationTask(priority, targetReference, this.nextId());
        return this.submitTask(compilationTask);
    }

    public CompilationTask submitInitialization(OptimizedCallTarget target, Consumer<CompilationTask> action) {
        WeakReference<OptimizedCallTarget> targetReference = new WeakReference<OptimizedCallTarget>(target);
        CompilationTask initializationTask = CompilationTask.createInitializationTask(targetReference, action);
        return this.submitTask(initializationTask);
    }

    private long nextId() {
        return this.idCounter.getAndIncrement();
    }

    public int getQueueSize() {
        ThreadPoolExecutor threadPool = this.compilationExecutorService;
        if (threadPool != null) {
            return threadPool.getQueue().size();
        }
        return 0;
    }

    public Collection<OptimizedCallTarget> getQueuedTargets(EngineData engine) {
        CompilationTask.ExecutorServiceWrapper[] array;
        BlockingQueue<Runnable> queue = this.compilationQueue;
        if (queue == null) {
            return Collections.emptyList();
        }
        ArrayList<OptimizedCallTarget> queuedTargets = new ArrayList<OptimizedCallTarget>();
        for (CompilationTask.ExecutorServiceWrapper wrapper : array = queue.toArray(new CompilationTask.ExecutorServiceWrapper[0])) {
            OptimizedCallTarget target = (OptimizedCallTarget)wrapper.compileTask.targetRef.get();
            if (target == null || target.engine != engine) continue;
            queuedTargets.add(target);
        }
        return Collections.unmodifiableCollection(queuedTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndAwaitTermination(long timeout) {
        ThreadPoolExecutor threadPool;
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            threadPool = this.compilationExecutorService;
            if (threadPool == null) {
                this.shutdown = true;
                return;
            }
        }
        threadPool.shutdownNow();
        try {
            threadPool.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Could not terminate compiler threads. Check if there are runaway compilations that don't handle Thread#interrupt.", e2);
        }
    }

    protected void notifyIdleCompilerThread() {
    }

    private final class IdlingLinkedBlockingDeque<E>
    extends LinkedBlockingDeque<E> {
        private IdlingLinkedBlockingDeque() {
        }

        @Override
        public E takeFirst() throws InterruptedException {
            while (!BackgroundCompileQueue.this.compilationExecutorService.allowsCoreThreadTimeOut()) {
                Object elem = this.poll(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem == null) {
                    BackgroundCompileQueue.this.notifyIdleCompilerThread();
                    continue;
                }
                return elem;
            }
            return super.take();
        }

        @Override
        public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutMillis = unit.toMillis(timeout);
            if (timeoutMillis < BackgroundCompileQueue.this.delayMillis) {
                return super.pollFirst(timeout, unit);
            }
            while (timeoutMillis > BackgroundCompileQueue.this.delayMillis) {
                Object elem = super.pollFirst(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem != null) {
                    return elem;
                }
                BackgroundCompileQueue.this.notifyIdleCompilerThread();
                timeoutMillis -= BackgroundCompileQueue.this.delayMillis;
            }
            return super.pollFirst(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private final class IdlingPriorityBlockingQueue<E>
    extends PriorityBlockingQueue<E> {
        private IdlingPriorityBlockingQueue() {
        }

        @Override
        public E take() throws InterruptedException {
            while (!BackgroundCompileQueue.this.compilationExecutorService.allowsCoreThreadTimeOut()) {
                Object elem = this.poll(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem == null) {
                    BackgroundCompileQueue.this.notifyIdleCompilerThread();
                    continue;
                }
                return elem;
            }
            return super.take();
        }
    }

    private final class TruffleCompilerThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final OptimizedTruffleRuntime runtime;

        TruffleCompilerThreadFactory(String namePrefix, OptimizedTruffleRuntime runtime) {
            this.namePrefix = namePrefix;
            this.runtime = runtime;
        }

        @Override
        public Thread newThread(Runnable r2) {
            Thread t2 = new Thread(r2){

                @Override
                public void run() {
                    this.setContextClassLoader(this.getClass().getClassLoader());
                    try (AutoCloseable compilerThreadScope = TruffleCompilerThreadFactory.this.runtime.openCompilerThreadScope();
                         AutoCloseable polyglotThreadScope = OptimizedRuntimeAccessor.ENGINE.createPolyglotThreadScope();){
                        super.run();
                        if (BackgroundCompileQueue.this.compilationExecutorService.allowsCoreThreadTimeOut()) {
                            BackgroundCompileQueue.this.notifyIdleCompilerThread();
                        }
                    }
                    catch (Exception e2) {
                        throw new InternalError(e2);
                    }
                }
            };
            t2.setName(this.namePrefix + "-" + t2.getId());
            t2.setPriority(10);
            t2.setDaemon(true);
            return t2;
        }
    }

    static class Priority {
        public static final Priority INITIALIZATION = new Priority(0, Tier.INITIALIZATION);
        final Tier tier;
        final int value;

        Priority(int value, Tier tier) {
            this.value = value;
            this.tier = tier;
        }

        public static enum Tier {
            INITIALIZATION,
            FIRST,
            LAST;

        }
    }
}

