/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.TypedArrayFunctionBuiltins;
import com.oracle.truffle.js.builtins.TypedArrayPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.util.List;

public final class JSArrayBufferView
extends JSNonProxy {
    public static final TruffleString CLASS_NAME = Strings.constant("TypedArray");
    public static final TruffleString PROTOTYPE_NAME = Strings.concat(CLASS_NAME, Strings.DOT_PROTOTYPE);
    private static final TruffleString BYTES_PER_ELEMENT = Strings.constant("BYTES_PER_ELEMENT");
    public static final JSArrayBufferView INSTANCE = new JSArrayBufferView();

    public static TypedArray typedArrayGetArrayType(JSDynamicObject thisObj) {
        return ((JSTypedArrayObject)thisObj).getArrayType();
    }

    public static int typedArrayGetLength(JSDynamicObject thisObj) {
        return ((JSTypedArrayObject)thisObj).getLength();
    }

    public static int typedArrayGetOffset(JSDynamicObject thisObj) {
        return ((JSTypedArrayObject)thisObj).getOffset();
    }

    public static TruffleString typedArrayGetName(JSDynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetArrayType(thisObj).getName();
    }

    private JSArrayBufferView() {
    }

    public static JSArrayBufferObject getArrayBuffer(JSDynamicObject thisObj) {
        return ((JSTypedArrayObject)thisObj).getArrayBuffer();
    }

    public static int getByteLength(JSDynamicObject store, JSContext ctx) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)store, ctx)) {
            return 0;
        }
        TypedArray typedArray = JSArrayBufferView.typedArrayGetArrayType(store);
        return typedArray.lengthInt(store) * typedArray.bytesPerElement();
    }

    public static int getByteOffset(JSDynamicObject store, JSContext ctx) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)store, ctx)) {
            return 0;
        }
        return JSArrayBufferView.typedArrayGetOffset(store);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(JSDynamicObject store, Object receiver, long index, Node encapsulatingNode) {
        return this.getOwnHelper(store, receiver, index, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object receiver, long index, Node encapsulatingNode) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)store, store.getJSContext())) {
            return Undefined.instance;
        }
        return JSArrayBufferView.typedArrayGetArrayType(store).getElement(store, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(JSDynamicObject store, Object receiver, Object key, Node encapsulatingNode) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            return JSArrayBufferView.integerIndexedElementGet(store, numericIndex);
        }
        return super.getHelper(store, receiver, key, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object receiver, Object key, Node encapsulatingNode) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            return JSArrayBufferView.integerIndexedElementGet(store, numericIndex);
        }
        return super.getOwnHelper(store, receiver, key, encapsulatingNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object integerIndexedElementGet(JSDynamicObject thisObj, Object numericIndex) {
        assert (JSRuntime.isNumber(numericIndex));
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
            return Undefined.instance;
        }
        if (!JSRuntime.isInteger(numericIndex)) {
            return Undefined.instance;
        }
        if (numericIndex instanceof Double && JSRuntime.isNegativeZero((Double)numericIndex)) {
            return Undefined.instance;
        }
        long index = ((Number)numericIndex).longValue();
        int length = ((JSTypedArrayObject)thisObj).getLength();
        if (index < 0L || index >= (long)length) {
            return Undefined.instance;
        }
        return JSArrayBufferView.typedArrayGetArrayType(thisObj).getElement(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (thisObj == receiver) {
            Object numValue = JSArrayBufferView.convertValue(thisObj, value);
            if (!JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
                JSArrayBufferView.typedArrayGetArrayType(thisObj).setElement(thisObj, index, numValue, isStrict);
            }
            return true;
        }
        if (!JSArrayBufferView.isValidIntegerIndex(thisObj, index)) {
            return true;
        }
        return super.set(thisObj, index, value, receiver, isStrict, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            if (thisObj == receiver) {
                Object numValue = JSArrayBufferView.convertValue(thisObj, value);
                long index = JSArrayBufferView.validIntegerIndex(thisObj, (Number)numericIndex);
                if (index != -1L) {
                    JSArrayBufferView.typedArrayGetArrayType(thisObj).setElement(thisObj, index, numValue, isStrict);
                }
                return true;
            }
            if (!JSArrayBufferView.isValidIntegerIndex(thisObj, (Number)numericIndex)) {
                return true;
            }
        }
        return super.set(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    public static boolean isValidIntegerIndex(JSDynamicObject thisObj, Number numericIndex) {
        return JSArrayBufferView.validIntegerIndex(thisObj, numericIndex) != -1L;
    }

    @CompilerDirectives.TruffleBoundary
    private static long validIntegerIndex(JSDynamicObject thisObj, Number numericIndex) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
            return -1L;
        }
        if (!JSRuntime.isInteger(numericIndex)) {
            return -1L;
        }
        if (numericIndex instanceof Double && JSRuntime.isNegativeZero((Double)numericIndex)) {
            return -1L;
        }
        int length = JSArrayBufferView.typedArrayGetLength(thisObj);
        long index = numericIndex.longValue();
        return 0L <= index && index < (long)length ? index : -1L;
    }

    private static Object convertValue(JSDynamicObject thisObj, Object value) {
        return JSArrayBufferView.isBigIntArrayBufferView(thisObj) ? JSRuntime.toBigInt(value) : JSRuntime.toNumber(value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(JSDynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(JSDynamicObject thisObj, Object key) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            return JSArrayBufferView.hasNumericIndex(thisObj, numericIndex);
        }
        return super.hasProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, long index) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
            return false;
        }
        return JSArrayBufferView.typedArrayGetArrayType(thisObj).hasElement(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, Object key) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            return JSArrayBufferView.hasNumericIndex(thisObj, numericIndex);
        }
        return super.hasOwnProperty(thisObj, key);
    }

    private static boolean hasNumericIndex(JSDynamicObject thisObj, Object numericIndex) {
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
            return false;
        }
        if (!JSRuntime.isInteger(numericIndex)) {
            return false;
        }
        double d2 = JSRuntime.doubleValue((Number)numericIndex);
        if (JSRuntime.isNegativeZero(d2) || d2 < 0.0) {
            return false;
        }
        return d2 < (double)JSArrayBufferView.typedArrayGetLength(thisObj);
    }

    public static JSTypedArrayObject createArrayBufferView(JSContext context, JSRealm realm, JSArrayBufferObject arrayBuffer, TypedArray arrayType, int offset, int length) {
        CompilerAsserts.partialEvaluationConstant(arrayType);
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        JSObjectFactory objectFactory = context.getArrayBufferViewFactory(arrayType.getFactory());
        return JSArrayBufferView.createArrayBufferView(objectFactory, realm, arrayBuffer, arrayType, offset, length);
    }

    public static JSTypedArrayObject createArrayBufferView(JSObjectFactory objectFactory, JSRealm realm, JSArrayBufferObject arrayBuffer, TypedArray arrayType, int offset, int length) {
        return JSArrayBufferView.createArrayBufferView(objectFactory, realm, arrayBuffer, arrayType, offset, length, objectFactory.getPrototype(realm));
    }

    public static JSTypedArrayObject createArrayBufferViewWithProto(JSObjectFactory objectFactory, JSRealm realm, JSArrayBufferObject arrayBuffer, TypedArray arrayType, int offset, int length, JSDynamicObject prototype) {
        return JSArrayBufferView.createArrayBufferView(objectFactory, realm, arrayBuffer, arrayType, offset, length, prototype);
    }

    private static JSTypedArrayObject createArrayBufferView(JSObjectFactory objectFactory, JSRealm realm, JSArrayBufferObject arrayBuffer, TypedArray arrayType, int offset, int length, JSDynamicObject prototype) {
        assert (!JSArrayBuffer.isDetachedBuffer(arrayBuffer));
        assert (offset >= 0 && offset + length * arrayType.bytesPerElement() <= arrayBuffer.getByteLength());
        assert (offset != 0 == arrayType.hasOffset());
        Shape shape = objectFactory.getShape(realm, prototype);
        JSTypedArrayObject newObj = objectFactory.initProto(new JSTypedArrayObject(shape, prototype, arrayType, arrayBuffer, length, offset), realm, prototype);
        return objectFactory.trackAllocation(newObj);
    }

    private static JSObject createArrayBufferViewPrototype(JSRealm realm, JSDynamicObject ctor, int bytesPerElement, TypedArrayFactory factory, JSDynamicObject taPrototype) {
        JSContext context = realm.getContext();
        JSObject prototype = context.getEcmaScriptVersion() >= 6 ? JSObjectUtil.createOrdinaryPrototypeObject(realm, taPrototype) : JSArrayBufferView.createLegacyArrayBufferViewPrototype(realm, factory, taPrototype);
        JSObjectUtil.putDataProperty(prototype, BYTES_PER_ELEMENT, bytesPerElement, JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        return prototype;
    }

    private static JSObject createLegacyArrayBufferViewPrototype(JSRealm realm, TypedArrayFactory factory, JSDynamicObject taPrototype) {
        JSContext context = realm.getContext();
        byte[] byteArray = new byte[]{};
        JSObjectFactory bufferFactory = context.getArrayBufferFactory();
        JSArrayBufferObject emptyArrayBuffer = bufferFactory.initProto(JSArrayBufferObject.createHeapArrayBuffer(bufferFactory.getShape(realm), bufferFactory.getPrototype(realm), byteArray), realm);
        TypedArray arrayType = factory.createArrayType((byte)0, false, true);
        Shape shape = JSShape.createPrototypeShape(context, INSTANCE, taPrototype);
        JSTypedArrayObject prototype = JSTypedArrayObject.create(shape, taPrototype, arrayType, emptyArrayBuffer, 0, 0);
        JSObjectUtil.setOrVerifyPrototype(context, prototype, taPrototype);
        return prototype;
    }

    public static Shape makeInitialArrayBufferViewShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm, TypedArrayFactory factory, JSConstructor taConstructor) {
        JSFunctionObject arrayBufferViewConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, factory.getName());
        JSObject.setPrototype(arrayBufferViewConstructor, taConstructor.getFunctionObject());
        JSObject arrayBufferViewPrototype = JSArrayBufferView.createArrayBufferViewPrototype(realm, arrayBufferViewConstructor, factory.getBytesPerElement(), factory, taConstructor.getPrototype());
        JSObjectUtil.putConstructorPrototypeProperty(arrayBufferViewConstructor, arrayBufferViewPrototype);
        JSObjectUtil.putDataProperty(arrayBufferViewConstructor, BYTES_PER_ELEMENT, factory.getBytesPerElement(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(arrayBufferViewConstructor, arrayBufferViewPrototype);
    }

    private static JSObject createTypedArrayPrototype(JSRealm realm, JSDynamicObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TypedArrayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TypedArrayPrototypeBuiltins.BUILTINS);
        Object valuesFunction = JSDynamicObject.getOrNull(prototype, Strings.VALUES);
        JSObjectUtil.putDataProperty(prototype, Symbol.SYMBOL_ITERATOR, valuesFunction, JSAttributes.getDefaultNotEnumerable());
        Object toStringFunction = JSDynamicObject.getOrNull(realm.getArrayPrototype(), Strings.TO_STRING);
        JSObjectUtil.putDataProperty(prototype, Strings.TO_STRING, toStringFunction, JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    public static JSConstructor createTypedArrayConstructor(JSRealm realm) {
        JSFunctionObject taConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, CLASS_NAME);
        JSObject taPrototype = JSArrayBufferView.createTypedArrayPrototype(realm, taConstructor);
        JSObjectUtil.putConstructorPrototypeProperty(taConstructor, taPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, taConstructor, TypedArrayFunctionBuiltins.BUILTINS);
        JSArrayBufferView.putConstructorSpeciesGetter(realm, taConstructor);
        return new JSConstructor(taConstructor, taPrototype);
    }

    public static boolean isJSArrayBufferView(Object obj) {
        return obj instanceof JSTypedArrayObject;
    }

    public static boolean isBigIntArrayBufferView(JSDynamicObject obj) {
        return JSArrayBufferView.typedArrayGetArrayType(obj) instanceof TypedArray.TypedBigIntArray;
    }

    public static boolean isOutOfBounds(JSTypedArrayObject typedArray, JSContext ctx) {
        if (!ctx.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBufferView.hasDetachedBuffer(typedArray)) {
            return true;
        }
        if (ctx.getArrayBufferNotShrunkAssumption().isValid()) {
            return false;
        }
        long bufferByteLength = typedArray.getArrayBuffer().getByteLength();
        int byteOffsetStart = typedArray.getOffset();
        long byteOffsetEnd = typedArray.hasAutoLength() ? bufferByteLength : (long)(byteOffsetStart + typedArray.getLength() * typedArray.getArrayType().bytesPerElement());
        return (long)byteOffsetStart > bufferByteLength || byteOffsetEnd > bufferByteLength;
    }

    private static boolean hasDetachedBuffer(JSDynamicObject obj) {
        assert (JSArrayBufferView.isJSArrayBufferView(obj));
        return JSArrayBuffer.isDetachedBuffer(JSArrayBufferView.getArrayBuffer(obj));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(JSDynamicObject thisObj, boolean strings, boolean symbols) {
        if (!strings) {
            return super.getOwnPropertyKeys(thisObj, strings, symbols);
        }
        List<Object> keys = JSArrayBufferView.ordinaryOwnPropertyKeys(thisObj, strings, symbols);
        if (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
            return keys;
        }
        List<Object> indices = JSArrayBufferView.typedArrayGetArrayType(thisObj).ownPropertyKeys(thisObj);
        return IteratorUtil.concatLists(indices, keys);
    }

    @Override
    public boolean defineOwnProperty(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor, boolean doThrow) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            boolean success = JSArrayBufferView.defineOwnPropertyIndex(thisObj, (Number)numericIndex, descriptor);
            if (doThrow && !success) {
                throw Errors.createTypeErrorCannotRedefineProperty(numericIndex);
            }
            return success;
        }
        return super.defineOwnProperty(thisObj, key, descriptor, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean defineOwnPropertyIndex(JSDynamicObject thisObj, Number numericIndex, PropertyDescriptor desc) {
        long index = JSArrayBufferView.validIntegerIndex(thisObj, numericIndex);
        if (index == -1L) {
            return false;
        }
        if (desc.isAccessorDescriptor()) {
            return false;
        }
        if (desc.hasConfigurable() && !desc.getConfigurable()) {
            return false;
        }
        if (desc.hasEnumerable() && !desc.getEnumerable()) {
            return false;
        }
        if (desc.hasWritable() && !desc.getWritable()) {
            return false;
        }
        if (desc.hasValue()) {
            Object value = desc.getValue();
            Object numValue = JSArrayBufferView.convertValue(thisObj, value);
            if (!JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)thisObj, thisObj.getJSContext())) {
                assert (index >= 0L && index < (long)JSArrayBufferView.typedArrayGetLength(thisObj));
                JSArrayBufferView.typedArrayGetArrayType(thisObj).setElement(thisObj, index, numValue, true);
            }
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key) {
        TruffleString name;
        long numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.propertyKeyToIntegerIndex(name = (TruffleString)key)) >= 0L) {
            Object value = this.getOwnHelper(thisObj, (Object)thisObj, numericIndex, (Node)null);
            if (value == Undefined.instance) {
                return null;
            }
            return PropertyDescriptor.createData(value, true, true, true);
        }
        return JSArrayBufferView.ordinaryGetOwnProperty(thisObj, key);
    }

    @Override
    public boolean delete(JSDynamicObject thisObj, Object key, boolean isStrict) {
        TruffleString name;
        Object numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (key instanceof TruffleString && (numericIndex = JSRuntime.canonicalNumericIndexString(name = (TruffleString)key)) != Undefined.instance) {
            if (JSArrayBufferView.hasNumericIndex(thisObj, numericIndex)) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            return true;
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

