/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDataClient;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.http.DiagnosticsWebServer;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsSubscribePacket;
import org.cyclops.integrateddynamics.proxy.ClientProxy;

public class NetworkDiagnosticsTriggerClient
extends PacketCodec {
    public static final CustomPacketPayload.Type<NetworkDiagnosticsTriggerClient> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"network_diagnostics_trigger"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NetworkDiagnosticsTriggerClient> CODEC = NetworkDiagnosticsTriggerClient.getCodec(NetworkDiagnosticsTriggerClient::new);
    @CodecField
    private boolean start;
    @CodecField
    private int port;

    public NetworkDiagnosticsTriggerClient(boolean start, int port) {
        super(ID);
        this.start = start;
        this.port = port;
    }

    public NetworkDiagnosticsTriggerClient() {
        this(true, 0);
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (this.start) {
            if (ClientProxy.DIAGNOSTICS_SERVER == null) {
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.subscribe());
                new Thread(() -> {
                    ClientProxy.DIAGNOSTICS_SERVER = new DiagnosticsWebServer(this.port);
                    ClientProxy.DIAGNOSTICS_SERVER.initialize();
                    player.sendSystemMessage((Component)Component.literal((String)"Diagnostics server has been started on ").append((Component)Component.literal((String)ClientProxy.DIAGNOSTICS_SERVER.getUrl()).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, ClientProxy.DIAGNOSTICS_SERVER.getUrl())))));
                }).start();
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Diagnostics server is already running on ").append((Component)Component.literal((String)ClientProxy.DIAGNOSTICS_SERVER.getUrl()).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, ClientProxy.DIAGNOSTICS_SERVER.getUrl())))));
            }
        } else if (ClientProxy.DIAGNOSTICS_SERVER != null) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.unsubscribe());
            new Thread(() -> {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
                NetworkDataClient.clearNetworkData();
                ClientProxy.DIAGNOSTICS_SERVER.deinitialize();
                ClientProxy.DIAGNOSTICS_SERVER = null;
                player.sendSystemMessage((Component)Component.literal((String)"Stopped diagnostics server"));
            }).start();
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"No diagnostics server is running"));
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

