/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.client.render.model.FacadeModel;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends Item
implements IDynamicModelElement {
    public ItemFacade(Item.Properties properties) {
        super(properties);
    }

    public BlockState getFacadeBlock(ItemStack itemStack) {
        return (BlockState)itemStack.get(RegistryEntries.DATACOMPONENT_FACADE_BLOCK);
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        BlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, BlockState blockState) {
        itemStack.set(RegistryEntries.DATACOMPONENT_FACADE_BLOCK, (Object)blockState);
    }

    public Component getName(ItemStack itemStack) {
        MutableComponent suffix = Component.translatable((String)"general.integrateddynamics.info.none").withStyle(ChatFormatting.ITALIC);
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).getHoverName();
        }
        return ((MutableComponent)super.getName(itemStack)).append(" - ").append((Component)suffix);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (!context.getLevel().isClientSide()) {
            IFacadeable facadeable = BlockEntityHelpers.getCapability((ILevelExtension)context.getLevel(), (BlockPos)context.getClickedPos(), null, Capabilities.Facadeable.BLOCK).orElse(null);
            BlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeable != null && blockState != null && !facadeable.hasFacade()) {
                facadeable.setFacade(blockState);
                ItemBlockCable.playPlaceSound(context.getLevel(), context.getClickedPos());
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel createDynamicModel(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation location = new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)this), "inventory");
        FacadeModel.emptyModel = (BakedModel)event.getModels().get(location);
        return new FacadeModel();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Color
    implements ItemColor {
        public int getColor(ItemStack itemStack, int color) {
            BlockState blockstate = ((ItemFacade)itemStack.getItem()).getFacadeBlock(itemStack);
            return Minecraft.getInstance().getBlockColors().getColor(blockstate, null, null, color);
        }
    }
}

