/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamics.item.ItemFacade;

public class RecipeSqueezerFacade
extends RecipeSqueezer {
    public static RecipeSqueezer.IngredientChance OUTPUT = new RecipeSqueezer.IngredientChance((Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>>)Either.left((Object)Pair.of((Object)new ItemStack(RegistryEntries.ITEM_FACADE), (Object)Float.valueOf(1.0f))));
    public static final RecipeSqueezerFacade INSTANCE = new RecipeSqueezerFacade();

    private RecipeSqueezerFacade() {
        super(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(RegistryEntries.ITEM_FACADE)}), (NonNullList<RecipeSqueezer.IngredientChance>)NonNullList.of((Object)OUTPUT, (Object[])new RecipeSqueezer.IngredientChance[]{OUTPUT}), Optional.empty());
    }

    @Override
    public NonNullList<RecipeSqueezer.IngredientChance> assemble(ItemStack inputItem) {
        return RecipeSqueezerFacade.getOutput(inputItem);
    }

    public static NonNullList<RecipeSqueezer.IngredientChance> getOutput(ItemStack inputItem) {
        ItemFacade inputFacade = (ItemFacade)inputItem.getItem();
        ItemStack facadeBlockItem = inputFacade.getFacadeBlockItem(inputItem);
        if (facadeBlockItem == null) {
            return NonNullList.of((Object)OUTPUT, (Object[])new RecipeSqueezer.IngredientChance[]{OUTPUT});
        }
        Either inputItemEither = Either.left((Object)facadeBlockItem);
        RecipeSqueezer.IngredientChance outputItemChance = new RecipeSqueezer.IngredientChance((Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>>)inputItemEither.mapBoth(i -> Pair.of((Object)i, (Object)Float.valueOf(1.0f)), i -> Pair.of((Object)i, (Object)Float.valueOf(1.0f))));
        return NonNullList.of((Object)outputItemChance, (Object[])new RecipeSqueezer.IngredientChance[]{outputItemChance, OUTPUT});
    }

    @Override
    public boolean matches(CraftingInput inv, Level worldIn) {
        return inv.getItem(0).getItem() instanceof ItemFacade && inv.getItem(0).has(RegistryEntries.DATACOMPONENT_FACADE_BLOCK);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_SQUEEZER_FACADE.get();
    }
}

