/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.OperatorLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

@OnlyIn(value=Dist.CLIENT)
class OperatorLPElementRenderPattern
extends RenderPattern<OperatorLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
implements IRenderPatternValueTypeTooltip {
    private boolean renderTooltip = true;

    public OperatorLPElementRenderPattern(OperatorLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        IConfigRenderPattern configRenderPattern = ((OperatorLPElement)this.element).getRenderPattern();
        IOperator operator = ((OperatorLPElement)this.element).getOperator();
        IValueType[] valueTypes = operator.getInputTypes();
        for (int i = 0; i < valueTypes.length; ++i) {
            IValueType valueType = valueTypes[i];
            SimpleInventory temporaryInputSlots = ((ContainerLogicProgrammerBase)this.container).getTemporaryInputSlots();
            if (!temporaryInputSlots.getItem(i).isEmpty()) continue;
            Pair<Integer, Integer> slotPosition = configRenderPattern.getSlotPositions()[i];
            if (!((ContainerScreenLogicProgrammerBase)this.gui).isHovering(this.getX() + (Integer)slotPosition.getLeft(), this.getY() + (Integer)slotPosition.getRight(), 18, 18, mouseX, mouseY)) continue;
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip(this.getValueTypeTooltip(valueType), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop);
        }
        this.drawTooltipForeground((ContainerScreenLogicProgrammerBase)this.gui, guiGraphics, (ContainerLogicProgrammerBase)this.container, guiLeft, guiTop, mouseX, mouseY, operator.getOutputType());
    }

    @Override
    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    @Override
    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }
}

