/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;

public class BlockEntityMechanicalSqueezer
extends BlockEntityMechanicalMachine<ItemStack, RecipeMechanicalSqueezer>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private static final int TANK_SIZE = 100000;
    @NBTPersist
    private boolean autoEjectFluids = false;
    private final SingleUseTank tank = new SingleUseTank(100000);

    public BlockEntityMechanicalSqueezer(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MECHANICAL_SQUEEZER.get(), blockPos, blockState, 5);
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<ItemStack, Optional<RecipeHolder<RecipeMechanicalSqueezer>>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeHolder<RecipeMechanicalSqueezer>>>(){

            public Optional<RecipeHolder<RecipeMechanicalSqueezer>> getNewValue(ItemStack key) {
                return CraftingHelpers.findServerRecipe(BlockEntityMechanicalSqueezer.this.getRecipeRegistry(), (RecipeInput)CraftingInput.of((int)1, (int)1, (List)Lists.newArrayList((Object[])new ItemStack[]{key})), (Level)BlockEntityMechanicalSqueezer.this.getLevel());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.matches((ItemStack)cacheKey, (ItemStack)newKey);
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.getLevel().getBlockState(this.getBlockPos()).getValue((Property)BlockMechanicalSqueezer.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getLevel().getBlockState(this.getBlockPos()).setValue((Property)BlockMechanicalSqueezer.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.getTank().readFromNBT(provider, tag.getCompound("tank"));
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("tank", (Tag)this.getTank().writeToNBT(provider, new CompoundTag()));
        super.saveAdditional(tag, provider);
    }

    @Override
    protected RecipeType<RecipeMechanicalSqueezer> getRecipeRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get();
    }

    @Override
    protected ItemStack getCurrentRecipeCacheKey() {
        return this.getInventory().getItem(0).copy();
    }

    @Override
    public int getRecipeDuration(RecipeHolder<RecipeMechanicalSqueezer> recipe) {
        return ((RecipeMechanicalSqueezer)recipe.value()).getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalSqueezer recipe, boolean simulate) {
        NonNullList outputStacks = NonNullList.create();
        for (RecipeSqueezer.IngredientChance itemStackChance : recipe.assemble(this.getInventory().getItem(0))) {
            ItemStack outputStack = itemStackChance.getIngredientFirst().copy();
            if (outputStack.isEmpty() || !simulate && itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= this.getLevel().random.nextFloat())) continue;
            InventoryHelpers.addStackToList((NonNullList)outputStacks, (ItemStack)outputStack);
        }
        if (!InventoryHelpers.addToInventory((Container)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)outputStacks, (boolean)simulate).isEmpty()) {
            return false;
        }
        Optional<FluidStack> outputFluid = recipe.getOutputFluid();
        if (outputFluid.isPresent() && this.getTank().fill(outputFluid.get().copy(), FluidHelpers.simulateBooleanToAction((boolean)simulate)) != outputFluid.get().getAmount()) {
            return false;
        }
        if (!simulate) {
            this.getInventory().removeItem(0, 1);
        }
        return true;
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalSqueezerConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalSqueezerConfig.capacity;
    }

    public boolean isAutoEjectFluids() {
        return this.autoEjectFluids;
    }

    public void setAutoEjectFluids(boolean autoEjectFluids) {
        this.autoEjectFluids = autoEjectFluids;
        this.sendUpdate();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMechanicalSqueezer(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integrateddynamics.mechanical_squeezer");
    }

    public static class Ticker
    extends BlockEntityMechanicalMachine.Ticker<ItemStack, RecipeMechanicalSqueezer, BlockEntityMechanicalSqueezer> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityMechanicalSqueezer blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.isAutoEjectFluids() && !blockEntity.getTank().isEmpty()) {
                for (Direction side : Direction.values()) {
                    IFluidHandler handler = BlockEntityHelpers.getCapability((ILevelExtension)level, (BlockPos)pos.relative(side), (Object)side.getOpposite(), (BlockCapability)Capabilities.FluidHandler.BLOCK).orElse(null);
                    if (handler == null) continue;
                    FluidStack fluidStack = blockEntity.getTank().getFluid().copy();
                    fluidStack.setAmount(Math.min(BlockMechanicalSqueezerConfig.autoEjectFluidRate, fluidStack.getAmount()));
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                    blockEntity.getTank().drain(handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityMechanicalMachine.CapabilityRegistrar<BlockEntityMechanicalSqueezer> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityMechanicalSqueezer>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
            this.add(Capabilities.RecipeHandler.BLOCK, (blockEntity, direction) -> new RecipeHandlerSqueezer(() -> ((BlockEntityMechanicalSqueezer)((Object)blockEntity)).getLevel(), (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get()));
        }
    }
}

