/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.ingredient;

import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;

public interface IIngredientComponentStorageObservable<T, M> {
    public IngredientComponent<T, M> getComponent();

    public void addObserver(IIndexChangeObserver<T, M> var1);

    public void removeObserver(IIndexChangeObserver<T, M> var1);

    public void scheduleObservation();

    public void scheduleObservationForced(int var1, PartPos var2);

    public boolean shouldObserve();

    public boolean isObservationForcedPending(int var1);

    public void runObserverSync();

    public IIngredientPositionsIndex<T, M> getChannelIndex(int var1);

    public static enum Change {
        ADDITION,
        DELETION;

    }

    public static class StorageChangeEvent<T, M> {
        private final int channel;
        private final PrioritizedPartPos pos;
        private final Change changeType;
        private final boolean completeChange;
        private final IIngredientCollection<T, M> instances;
        private final boolean initialChange;

        public StorageChangeEvent(int channel, PrioritizedPartPos pos, Change changeType, boolean completeChange, IIngredientCollection<T, M> instances, boolean initialChange) {
            this.channel = channel;
            this.pos = pos;
            this.changeType = changeType;
            this.completeChange = completeChange;
            this.instances = instances;
            this.initialChange = initialChange;
        }

        public int getChannel() {
            return this.channel;
        }

        public PrioritizedPartPos getPos() {
            return this.pos;
        }

        public Change getChangeType() {
            return this.changeType;
        }

        public boolean isCompleteChange() {
            return this.completeChange;
        }

        public IIngredientCollection<T, M> getInstances() {
            return this.instances;
        }

        public boolean isInitialChange() {
            return this.initialChange;
        }

        public String toString() {
            return String.format("[%s at %s(%s): %s]", this.getChangeType().name(), this.getPos(), this.getChannel(), this.getInstances());
        }

        public IngredientCollectionDiff<T, M> getDiff() {
            return new IngredientCollectionDiff(this.changeType == Change.ADDITION ? this.getInstances() : null, this.changeType == Change.DELETION ? this.getInstances() : null, false);
        }
    }

    public static interface IIndexChangeObserver<T, M> {
        public void onChange(StorageChangeEvent<T, M> var1);
    }
}

