/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class DryingBasinDataProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamicscompat", (String)"drying_basin");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (config.get(ID)) {
            tooltip.addAll((List)NBTClassType.getClassType(List.class).readPersistedField("tooltip", accessor.getServerData(), (HolderLookup.Provider)accessor.getLevel().registryAccess()));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntityDryingBasin tile = (BlockEntityDryingBasin)accessor.getBlockEntity();
        ArrayList tooltip = Lists.newArrayList();
        if (!tile.getInventory().getItem(0).isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.item", (Object[])new Object[]{tile.getInventory().getItem(0).getDisplayName()}));
        }
        if (!tile.getTank().isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.fluid", (Object[])new Object[]{tile.getTank().getFluid().getDisplayName(), tile.getTank().getFluidAmount()}));
        }
        NBTClassType.getClassType(List.class).writePersistedField("tooltip", (Object)tooltip, tag, (HolderLookup.Provider)accessor.getLevel().registryAccess());
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

