/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.event;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.cyclops.cyclopscore.helper.CollectionHelpers;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.event.ICancelableNetworkEvent;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.network.event.INetworkEventBus;

public class NetworkEventBus
implements INetworkEventBus {
    private final Map<Class<? extends INetworkEvent>, Set<IEventListenableNetworkElement<?>>> listeners = Collections.synchronizedMap(Maps.newHashMap());

    @Override
    public void register(IEventListenableNetworkElement<?> target, Class<? extends INetworkEvent> eventType) {
        CollectionHelpers.addToMapSet(this.listeners, eventType, target);
    }

    @Override
    public void unregister(IEventListenableNetworkElement<?> target, Class<? extends INetworkEvent> eventType) {
        Set<IEventListenableNetworkElement<?>> listeners = this.listeners.get(eventType);
        if (listeners != null) {
            listeners.remove(target);
        }
    }

    @Override
    public void unregister(IEventListenableNetworkElement<?> target) {
        target.getNetworkEventListener().ifPresent(listener -> {
            for (Class<INetworkEvent> eventType : listener.getSubscribedEvents()) {
                this.unregister(target, eventType);
            }
        });
    }

    @Override
    public void post(INetworkEvent event) {
        Set<IEventListenableNetworkElement<?>> listeners = this.listeners.get(event.getClass());
        if (listeners != null) {
            for (IEventListenableNetworkElement<?> listener : listeners) {
                listener.getNetworkEventListener().ifPresent(l -> l.onEvent(event, listener));
            }
        }
    }

    @Override
    public boolean postCancelable(ICancelableNetworkEvent event) {
        this.post(event);
        return !event.isCanceled();
    }
}

