/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityProxy;
import org.cyclops.integrateddynamics.core.block.BlockWithEntityGuiCabled;

public class BlockProxy
extends BlockWithEntityGuiCabled {
    public static final MapCodec<BlockProxy> CODEC = BlockProxy.simpleCodec(BlockProxy::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BlockProxy(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityProxy::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockProxy.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_PROXY.get()), new BlockEntityProxy.Ticker());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockPos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityProxy.class).ifPresent(tile -> {
                if (itemStack.has(RegistryEntries.DATACOMPONENT_PROXY_ID)) {
                    tile.setProxyId((Integer)itemStack.get(RegistryEntries.DATACOMPONENT_PROXY_ID));
                } else {
                    tile.generateNewProxyId();
                }
                tile.setChanged();
            });
        }
        super.setPlacedBy(world, blockPos, state, placer, itemStack);
    }
}

