/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import java.util.function.Predicate;

public class PositionedAddonsNetworkIngredientsFilter<T> {
    private final Predicate<T> filter;
    private final boolean applyToInsertions;
    private final boolean applyToExtractions;
    private final boolean allowAllIfFilterNotApplied;

    public PositionedAddonsNetworkIngredientsFilter(Predicate<T> filter, boolean applyToInsertions, boolean applyToExtractions, boolean allowAllIfFilterNotApplied) {
        this.filter = filter;
        this.applyToInsertions = applyToInsertions;
        this.applyToExtractions = applyToExtractions;
        this.allowAllIfFilterNotApplied = allowAllIfFilterNotApplied;
    }

    public boolean testInsertion(T ingredient) {
        if (this.isApplyToInsertions()) {
            return this.getFilter().test(ingredient);
        }
        return this.isAllowAllIfFilterNotApplied();
    }

    public boolean testExtraction(T ingredient) {
        if (this.isApplyToExtractions()) {
            return this.getFilter().test(ingredient);
        }
        return this.isAllowAllIfFilterNotApplied();
    }

    public boolean testView(T ingredient) {
        return this.testExtraction(ingredient);
    }

    public Predicate<T> getFilter() {
        return this.filter;
    }

    public boolean isApplyToInsertions() {
        return this.applyToInsertions;
    }

    public boolean isApplyToExtractions() {
        return this.applyToExtractions;
    }

    public boolean isAllowAllIfFilterNotApplied() {
        return this.allowAllIfFilterNotApplied;
    }
}

