/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.network.packet;

import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.item.Vajra;
import dev.wp.industrialization_overdrive.network.IOCustomPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record ModifyVajraSpeedPacket(boolean increase) implements IOCustomPacket
{
    public static final StreamCodec<ByteBuf, ModifyVajraSpeedPacket> STREAM_CODEC = ByteBufCodecs.BOOL.map(ModifyVajraSpeedPacket::new, ModifyVajraSpeedPacket::increase);

    public void handle(PacketContext ctx) {
        ctx.assertServerbound();
        Player player = ctx.getPlayer();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof Vajra) {
            int origSpeed;
            Vajra item2 = (Vajra)item;
            int speed = origSpeed = Vajra.getToolSpeed(stack);
            speed += this.increase ? 1 : -1;
            if ((speed = Math.clamp((long)speed, 1, 4)) != origSpeed) {
                Vajra.setToolSpeed(stack, speed);
                MutableComponent vajraSpeed = null;
                switch (speed) {
                    case 1: {
                        vajraSpeed = IO.text().vajraSpeedSlow();
                        break;
                    }
                    case 2: {
                        vajraSpeed = IO.text().vajraSpeedNormal();
                        break;
                    }
                    case 3: {
                        vajraSpeed = IO.text().vajraSpeedFast();
                        break;
                    }
                    case 4: {
                        vajraSpeed = IO.text().vajraSpeedInstant();
                    }
                }
                player.displayClientMessage((Component)IO.text().vajraSpeedChanged((Component)vajraSpeed), true);
            }
        }
    }
}

