/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive;

import com.google.common.collect.Sets;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOSortOrder;
import dev.wp.industrialization_overdrive.item.Terminal;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class IOItems {
    public static final ItemHolder<Terminal> TERMINAL = IOItems.create("terminal", "Multiblock Builder", Terminal::new, IOSortOrder.GEAR).withModelBuilder(CommonModelBuilders::generated).register();

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static Set<ItemHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    public static ItemHolder valueOf(String id) {
        return Registry.HOLDERS.stream().filter(holder -> holder.identifier().id().equals(id)).findFirst().orElseThrow();
    }

    public static <Type extends Item> ItemHolder<Type> create(String id, String englishName, Function<Item.Properties, Type> creator, SortOrder sortOrder) {
        ItemHolder holder = new ItemHolder(IO.id(id), englishName, Registry.ITEMS, creator).sorted(sortOrder);
        Registry.include(holder);
        return holder;
    }

    public static final class Registry {
        public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"industrialization_overdrive");
        private static final Set<ItemHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            ITEMS.register(bus);
        }

        public static void include(ItemHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

