/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransporterTESR
implements BlockEntityRenderer<TransporterTile> {
    public static ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/block/transporters/particle.png");
    public static RenderType TYPE = TransporterTESR.createRenderType();

    public TransporterTESR(BlockEntityRendererProvider.Context context) {
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, false)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).createCompositeState(true);
        return RenderType.create((String)"transporter_render", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static Vector3f getPath(Direction from, Direction to, double step, float partialTicks) {
        float totalSteps = 5.0f;
        if (from.getOpposite() == to) {
            totalSteps = 7.0f;
            Vec3 vector3d = new Vec3((double)(to.step().x() / totalSteps) * step, (double)(to.step().y() / totalSteps) * step, (double)(to.step().z() / totalSteps) * step);
            if (from.getAxis() == Direction.Axis.X) {
                vector3d = vector3d.add(0.0, 0.5, 0.5);
                if (from.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.add(1.0, 0.0, 0.0);
                }
            }
            if (from.getAxis() == Direction.Axis.Z) {
                vector3d = vector3d.add(0.5, 0.5, 0.0);
                if (from.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.add(0.0, 0.0, 1.0);
                }
            }
            if (from.getAxis() == Direction.Axis.Y) {
                vector3d = vector3d.add(0.5, 0.0, 0.5);
                if (from.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.add(0.0, 1.0, 0.0);
                }
            }
            float divideSecond = -0.22f;
            vector3d = vector3d.add((double)(from.step().x() * divideSecond), (double)(from.step().y() * divideSecond), (double)(from.step().z() * divideSecond));
            return new Vector3f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
        }
        Vector3f vsrc = from.step();
        Vector3f vdst = to.step();
        Vector3f a = new Vector3f((Vector3fc)vsrc);
        a.mul(0.3125f);
        Vector3f b = new Vector3f((Vector3fc)vdst);
        b.mul(0.375f);
        Vector3f c = new Vector3f((Vector3fc)vsrc);
        c.mul(0.1875f);
        float sind = -Mth.sin((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        float cosd = -Mth.cos((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        a.mul(sind);
        b.mul(cosd);
        a.add((Vector3fc)b);
        a.add((Vector3fc)c);
        float divide = 2.5f;
        a.add(vdst.x() / divide, vdst.y() / divide, vdst.z() / divide);
        a.add(0.5f, 0.5f, 0.5f);
        float divideSecond = 0.15f;
        a.add(vsrc.x() * divideSecond, vsrc.y() * divideSecond, vsrc.z() * divideSecond);
        return a;
    }

    public void render(TransporterTile tile, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Map<Direction, TransporterType> transporters = tile.getTransporterTypeMap();
        for (Direction direction : transporters.keySet()) {
            if (transporters.get(direction).getAction() != TransporterTypeFactory.TransporterAction.EXTRACT) continue;
            for (Direction other : transporters.keySet()) {
                if (direction == other || !transporters.get(direction).getFactory().getName().equals(transporters.get(other).getFactory().getName()) || transporters.get(other).getAction() == TransporterTypeFactory.TransporterAction.EXTRACT) continue;
                for (int i = -1; i < 6; ++i) {
                    stack.pushPose();
                    Vector3f pos = TransporterTESR.getPath(direction, other, (float)i + partialTicks, partialTicks);
                    stack.translate(pos.x(), pos.y(), pos.z());
                    transporters.get(other).renderTransfer(pos, direction, i + 1, stack, combinedOverlayIn, buffer, partialTicks, tile.getLevel());
                    stack.popPose();
                }
            }
        }
    }
}

