/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon;

import com.buuz135.industrial.item.addon.AddonItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class EfficiencyAddonItem
extends AddonItem
implements ISpecialCreativeTabItem {
    private int tier;

    public EfficiencyAddonItem(int tier, TitaniumTab group) {
        super("efficiency_addon_tier_" + tier, group, new Item.Properties().stacksTo(16));
        this.tier = tier;
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.EFFICIENCY, (float)(1.0f - (float)this.tier * 0.1f));
    }

    public void registerRecipe(RecipeOutput consumer) {
        TagKey<Item> tierMaterial = this.tier == 1 ? IndustrialTags.Items.GEAR_GOLD : IndustrialTags.Items.GEAR_DIAMOND;
        DissolutionChamberRecipe.createRecipe(consumer, "efficiency_addon_tier_" + this.tier, new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of(tierMaterial), Ingredient.of(tierMaterial), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BLAZE_ROD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BLAZE_ROD)})), new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1000), 200, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    public String getDescriptionId() {
        return Component.translatable((String)"item.industrialforegoing.addon").getString() + Component.translatable((String)"item.industrialforegoing.efficiency").getString() + Component.translatable((String)"item.industrialforegoing.tier").getString() + this.tier + " ";
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"text.industrialforegoing.tooltip.efficiency").getString() + "-" + this.tier * 10 + "%")));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack = new ItemStack((ItemLike)this);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.EFFICIENCY, (float)(1.0f - (float)this.tier * 0.1f));
        event.accept(stack);
    }
}

