/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class HydroponicSimulationProcessorItem
extends IFCustomItem {
    public HydroponicSimulationProcessorItem(TitaniumTab tab) {
        super("hydroponic_simulation_processor", tab, new Item.Properties().stacksTo(1));
    }

    public static double calculateEfficiency(long executions) {
        return Math.log(executions) / Math.log(200.0);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (!stack.has(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR)) {
            stack.set(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR, (Object)new CompoundTag());
        }
    }

    public void registerRecipe(RecipeOutput recipeOutput) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PCP").pattern("DRD").pattern("PGP").define(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('D'), (ItemLike)Items.OBSERVER).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('G'), IndustrialTags.Items.GEAR_DIAMOND).save(recipeOutput);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        Simulation simulation = new Simulation((CompoundTag)stack.get(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR));
        double effi = Math.floor(HydroponicSimulationProcessorItem.calculateEfficiency(simulation.executions) * 100.0) / 100.0;
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.simulating").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)(simulation.crop.isEmpty() ? "tooltip.industrialforegoing.hydroponic.nothing" : simulation.crop.getDescriptionId())).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.executions").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)new DecimalFormat().format(simulation.executions)).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.efficiency").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("" + effi)).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.next_efficiency").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)this.getProgressBar(simulation.executions)).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.potential_drops").withStyle(ChatFormatting.GRAY));
        for (CountedStack stat : simulation.stats) {
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + " - " + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat("0.00").format((double)stat.amount / (double)simulation.executions * effi) + String.valueOf(ChatFormatting.GRAY) + "x " + String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)stat.stack.getDescriptionId()).getString())));
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.function_1").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.industrialforegoing.hydroponic.function_2").withStyle(ChatFormatting.DARK_GRAY));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    private String getProgressBar(long executions) {
        double currentEff = Math.floor(HydroponicSimulationProcessorItem.calculateEfficiency(executions) * 100.0) / 100.0;
        double nextEff = this.calculateNextEfficiency(currentEff);
        double lastEff = Math.floor(currentEff * 100.0) / 100.0;
        lastEff = this.calculateNextEfficiency(lastEff - 0.01);
        int linesAmount = 30;
        int progress = (int)Math.floor(((double)executions - lastEff) / (nextEff - lastEff) * (double)linesAmount);
        return String.valueOf(ChatFormatting.GOLD) + "[" + "|".repeat(progress) + String.valueOf(ChatFormatting.DARK_GRAY) + "|".repeat(linesAmount - progress) + String.valueOf(ChatFormatting.GOLD) + "]";
    }

    private double calculateNextEfficiency(double efficiency) {
        return Math.ceil(Math.pow(200.0, efficiency + 0.01));
    }

    public static class Simulation {
        private long executions;
        private ItemStack crop;
        private List<CountedStack> stats;

        public Simulation() {
            this.executions = 0L;
            this.crop = ItemStack.EMPTY;
            this.stats = new ArrayList<CountedStack>();
        }

        public Simulation(CompoundTag nbt) {
            this.crop = ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)nbt.getCompound("Crop"));
            this.executions = nbt.getLong("Executions");
            this.stats = new ArrayList<CountedStack>();
            CompoundTag statsCompound = nbt.getCompound("Stats");
            for (String allKey : statsCompound.getAllKeys()) {
                CompoundTag stat = statsCompound.getCompound(allKey);
                this.stats.add(new CountedStack(ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)stat.getCompound("Stack")), stat.getLong("Count")));
            }
        }

        public CompoundTag toNBT(HolderLookup.Provider levelRegistryAccess) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("Crop", this.crop.saveOptional(levelRegistryAccess));
            nbt.putLong("Executions", this.executions);
            CompoundTag allStats = new CompoundTag();
            int key = 0;
            for (CountedStack stat : this.stats) {
                CompoundTag statCompound = new CompoundTag();
                statCompound.put("Stack", stat.stack.saveOptional(levelRegistryAccess));
                statCompound.putLong("Count", stat.amount);
                allStats.put("" + key, (Tag)statCompound);
                ++key;
            }
            nbt.put("Stats", (Tag)allStats);
            return nbt;
        }

        public void acceptExecution(ItemStack crop, List<ItemStack> stacks) {
            if (this.crop.isEmpty()) {
                this.crop = crop.copyWithCount(1);
            }
            if (ItemStack.isSameItem((ItemStack)this.crop, (ItemStack)crop)) {
                ++this.executions;
                for (ItemStack itemStack : stacks) {
                    if (itemStack.isEmpty()) continue;
                    boolean found = false;
                    for (CountedStack stat : this.stats) {
                        if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)stat.stack)) continue;
                        found = true;
                        stat.amount += (long)itemStack.getCount();
                        break;
                    }
                    if (found) continue;
                    this.stats.add(new CountedStack(itemStack.copy(), itemStack.getCount()));
                }
            }
        }

        public long getExecutions() {
            return this.executions;
        }

        public ItemStack getCrop() {
            return this.crop;
        }

        public List<CountedStack> getStats() {
            return this.stats;
        }
    }

    public static final class CountedStack {
        private ItemStack stack;
        private long amount;

        private CountedStack(ItemStack stack, long amount) {
            this.stack = stack;
            this.amount = amount;
        }

        public ItemStack stack() {
            return this.stack;
        }

        public long amount() {
            return this.amount;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CountedStack that = (CountedStack)obj;
            return Objects.equals(this.stack, that.stack) && this.amount == that.amount;
        }

        public int hashCode() {
            return Objects.hash(this.stack, this.amount);
        }

        public String toString() {
            return "CountedStack[stack=" + String.valueOf(this.stack) + ", amount=" + this.amount + "]";
        }
    }
}

