/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluidInstance;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.fluid.ClientFluidTypeExtensions;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class OreTitaniumFluidType
extends FluidType {
    public static HashMap<String, TagKey<Item>> TAG_CACHE = new HashMap();

    public OreTitaniumFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public static FluidStack getFluidWithTag(OreFluidInstance fluidInstance, int amount, ResourceLocation itemITag) {
        FluidStack stack = new FluidStack(fluidInstance.getSourceFluid(), amount);
        stack.set(IFAttachments.ORE_FLUID_TAG, (Object)itemITag.toString());
        return stack;
    }

    public static String getFluidTag(FluidStack stack) {
        return (String)stack.getOrDefault(IFAttachments.ORE_FLUID_TAG, (Object)"");
    }

    public static boolean isValid(ResourceLocation resourceLocation) {
        TagKey key = TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + resourceLocation.toString().replace("c:raw_materials/", ""))));
        return BuiltInRegistries.ITEM.getTag(key).isPresent() && !TagUtil.getAllEntries((Registry)BuiltInRegistries.ITEM, (TagKey)key).isEmpty();
    }

    public static ItemStack getOutputDust(FluidStack stack) {
        String tag = OreTitaniumFluidType.getFluidTag(stack);
        if (TAG_CACHE.containsKey(tag)) {
            return TagUtil.getItemWithPreference(TAG_CACHE.get(tag));
        }
        TagKey itemTag = TagUtil.getItemTag((ResourceLocation)ResourceLocation.parse((String)tag.replace("c:raw_materials/", "c:dusts/")));
        TAG_CACHE.put(tag, (TagKey<Item>)itemTag);
        return TagUtil.getItemWithPreference((TagKey)itemTag);
    }

    public Component getDescription(FluidStack stack) {
        return super.getDescription(stack);
    }

    public String getDescriptionId(FluidStack stack) {
        String tag;
        List items;
        Object extra = "";
        if (stack.has(IFAttachments.ORE_FLUID_TAG) && (items = TagUtil.getAllEntries((Registry)BuiltInRegistries.ITEM, (TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.parse((String)(tag = (String)stack.get(IFAttachments.ORE_FLUID_TAG)).replace("c:raw_materials/", "c:dusts/")))).stream().toList()).size() > 0) {
            extra = " (" + Component.translatable((String)((Item)items.get(0)).getDescriptionId()).getString() + ")";
        }
        return Component.translatable((String)super.getDescriptionId(stack)).getString() + (String)extra;
    }

    public ItemStack getBucket(FluidStack stack) {
        ItemStack bucket = super.getBucket(stack);
        if (stack.has(IFAttachments.ORE_FLUID_TAG)) {
            String tag = (String)stack.get(IFAttachments.ORE_FLUID_TAG);
            bucket.set(IFAttachments.ORE_FLUID_TAG, (Object)tag);
        }
        return bucket;
    }

    public static class Client
    extends ClientFluidTypeExtensions {
        public Client(ResourceLocation still, ResourceLocation flow) {
            super(still, flow);
        }

        public int getTintColor(FluidStack stack) {
            String tag;
            List items;
            if (Minecraft.getInstance().level != null && stack.has(IFAttachments.ORE_FLUID_TAG) && (items = TagUtil.getAllEntries((Registry)BuiltInRegistries.ITEM, (TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.parse((String)(tag = (String)stack.get(IFAttachments.ORE_FLUID_TAG)).replace("c:raw_materials/", "c:dusts/")))).stream().toList()).size() > 0) {
                return ItemStackUtils.getColor(new ItemStack((ItemLike)items.get(0)));
            }
            return -1;
        }
    }
}

