/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.WaterCondensatorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WaterCondensatorTile
extends IndustrialWorkingTile<WaterCondensatorTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<WaterCondensatorTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", WaterCondensatorConfig.maxWaterTankSize, 43, 20, 0).setColor(DyeColor.BLUE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)Fluids.WATER));

    public WaterCondensatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.WATER_CONDENSATOR, WaterCondensatorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.water);
        this.getMaxProgress = WaterCondensatorConfig.maxProgress;
        this.getPowerPerOperation = WaterCondensatorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        int water = this.getWaterSources();
        if (water >= 2) {
            if (this.hasEnergy(this.getPowerPerOperation)) {
                this.water.fillForced(new FluidStack((Fluid)Fluids.WATER, water * 100), IFluidHandler.FluidAction.EXECUTE);
                return new IndustrialWorkingTile.WorkAction(this, 0.1f, this.getPowerPerOperation);
            }
            this.water.fillForced(new FluidStack((Fluid)Fluids.WATER, water * 50), IFluidHandler.FluidAction.EXECUTE);
            return new IndustrialWorkingTile.WorkAction(this, 0.5f, 0);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<WaterCondensatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(WaterCondensatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    private int getWaterSources() {
        int amount = 0;
        for (Direction value : Direction.values()) {
            FluidState fluidState;
            if (!this.level.hasChunksAt(this.worldPosition.relative(value), this.worldPosition.relative(value)) || !(fluidState = this.level.getFluidState(this.worldPosition.relative(value))).getType().equals(Fluids.WATER) || !fluidState.isSource()) continue;
            ++amount;
        }
        return amount;
    }

    @Nonnull
    public WaterCondensatorTile getSelf() {
        return this;
    }
}

