/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.FluidCollectorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidCollectorTile
extends IndustrialAreaWorkingTile<FluidCollectorTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<FluidCollectorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("output", FluidCollectorConfig.maxOutputTankSize, 43, 20, 0).setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);

    public FluidCollectorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FLUID_COLLECTOR, RangeManager.RangeType.BEHIND, false, FluidCollectorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.getMaxProgress = FluidCollectorConfig.maxProgress;
        this.getPowerPerOperation = FluidCollectorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pointed;
        if (this.hasEnergy(this.getPowerPerOperation) && this.isLoaded(pointed = this.getPointedBlockPos()) && !this.level.isEmptyBlock(pointed) && BlockUtils.canBlockBeBroken(this.level, pointed, this.getUuid()) && this.level.getFluidState(pointed).isSource()) {
            Fluid fluid = this.level.getFluidState(pointed).getType();
            if (this.tank.isEmpty() || this.tank.getFluid().getFluid().isSame(fluid) && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
                if (this.level.getBlockState(pointed).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    this.level.setBlockAndUpdate(pointed, (BlockState)this.level.getBlockState(pointed).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.level.setBlockAndUpdate(pointed, Blocks.AIR.defaultBlockState());
                }
                this.tank.fillForced(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<FluidCollectorTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidCollectorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public FluidCollectorTile getSelf() {
        return this;
    }
}

