/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PumpkinMelonPlantRecollectable
extends PlantRecollectable {
    public PumpkinMelonPlantRecollectable() {
        super("blockpumpkingandmelon");
    }

    @Override
    public boolean canBeHarvested(Level world, BlockPos pos, BlockState blockState) {
        return blockState.getBlock() instanceof PumpkinBlock || blockState.getBlock().equals(Blocks.MELON) || blockState.getBlock() instanceof AttachedStemBlock;
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState) {
        NonNullList stacks = NonNullList.create();
        if (blockState.getBlock() instanceof AttachedStemBlock) {
            stacks.addAll(BlockUtils.getBlockDrops(world, pos.relative((Direction)blockState.getValue((Property)AttachedStemBlock.FACING))));
            world.setBlockAndUpdate(pos.relative((Direction)blockState.getValue((Property)AttachedStemBlock.FACING)), Blocks.AIR.defaultBlockState());
        } else {
            stacks.addAll(BlockUtils.getBlockDrops(world, pos));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(Level world, BlockPos pos, BlockState blockState) {
        return true;
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.pumpkin", "text.industrialforegoing.plant.melon");
    }

    @Override
    public ItemStack getSeedDrop(Level world, BlockPos pos, BlockState blockState) {
        if (blockState.getBlock() instanceof AttachedStemBlock) {
            return blockState.getBlock().getCloneItemStack((LevelReader)world, pos, blockState);
        }
        return super.getSeedDrop(world, pos, blockState);
    }
}

