/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CraftingUtils {
    private static final Map<Integer, List<CraftingRecipe>> recipesBySize = new Int2ObjectArrayMap();

    public static ItemStack findOutput(int size, ItemStack input, Level world) {
        if (input.getCount() < size * size) {
            return ItemStack.EMPTY;
        }
        CraftingRecipe recipe = CraftingUtils.getRecipeFor(size, input, world);
        if (recipe != null) {
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)world.registryAccess());
            return output.copy();
        }
        return ItemStack.EMPTY;
    }

    private static List<CraftingRecipe> getRecipesWithSize(int size, Level world) {
        return recipesBySize.computeIfAbsent(size, k -> {
            RecipeManager recipeManager = world.getRecipeManager();
            return recipeManager.getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(recipe -> CraftingUtils.canCraftInDimensions(recipe, size) && CraftingUtils.allIngredientsEqual(recipe)).toList();
        });
    }

    private static boolean canCraftInDimensions(CraftingRecipe recipe, int size) {
        if (!recipe.canCraftInDimensions(size, size)) {
            return false;
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getWidth() == size && shapedRecipe.getHeight() == size;
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            return shapelessRecipe.getIngredients().size() == size * size;
        }
        return true;
    }

    private static boolean allIngredientsEqual(CraftingRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        int count = ingredients.size();
        if (count <= 1) {
            return true;
        }
        Ingredient firstIngredient = (Ingredient)ingredients.getFirst();
        for (int i = 1; i < count; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (firstIngredient.equals((Object)ingredient)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static CraftingRecipe getRecipeFor(int size, ItemStack input, Level world) {
        List<CraftingRecipe> craftingRecipes = CraftingUtils.getRecipesWithSize(size, world);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < size * size; ++i) {
            inputs.add(input.copy());
        }
        CraftingInput craftingInput = CraftingInput.of((int)size, (int)size, inputs);
        for (CraftingRecipe recipe : craftingRecipes) {
            if (!recipe.matches((RecipeInput)craftingInput, world)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getCrushOutput(Level world, ItemStack stack) {
        for (CrusherRecipe recipe : RecipeUtil.getRecipes((Level)world, (RecipeType)((RecipeType)ModuleCore.CRUSHER_TYPE.get()))) {
            if (!recipe.input.test(stack)) continue;
            return recipe.output.getItems()[0];
        }
        return ItemStack.EMPTY;
    }
}

