/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.Main;
import immersive_aircraft.cobalt.network.Message;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class InventoryUpdateMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryUpdateMessage> STREAM_CODEC = StreamCodec.ofMember(InventoryUpdateMessage::encode, InventoryUpdateMessage::new);
    public static final CustomPacketPayload.Type<InventoryUpdateMessage> TYPE = Message.createType("inventory_update");
    private final int vehicle;
    private final int index;
    private final Tag stack;

    public CustomPacketPayload.Type<InventoryUpdateMessage> type() {
        return TYPE;
    }

    public InventoryUpdateMessage(Entity entity, int index, ItemStack stack) {
        this.vehicle = entity.getId();
        this.index = index;
        this.stack = stack.isEmpty() ? null : stack.save((HolderLookup.Provider)entity.registryAccess());
    }

    public InventoryUpdateMessage(RegistryFriendlyByteBuf b) {
        this.vehicle = b.readInt();
        this.index = b.readInt();
        this.stack = b.readNbt();
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeInt(this.vehicle);
        b.writeInt(this.index);
        b.writeNbt(this.stack);
    }

    @Override
    public void receiveClient() {
        Main.messageHandler.handleInventoryUpdate(this);
    }

    public int getVehicle() {
        return this.vehicle;
    }

    public int getIndex() {
        return this.index;
    }

    public ItemStack getStack(Entity entity) {
        return this.stack == null ? ItemStack.EMPTY : ItemStack.parse((HolderLookup.Provider)entity.registryAccess(), (Tag)this.stack).orElse(ItemStack.EMPTY);
    }
}

