/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.InventoryVehicleEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;

public class FireMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, FireMessage> STREAM_CODEC = StreamCodec.ofMember(FireMessage::encode, FireMessage::new);
    public static final CustomPacketPayload.Type<FireMessage> TYPE = Message.createType("fire");
    private final int slot;
    private final int index;
    public final Vector3f direction;

    public CustomPacketPayload.Type<FireMessage> type() {
        return TYPE;
    }

    public FireMessage(int slot, int index, Vector3f direction) {
        this.slot = slot;
        this.index = index;
        this.direction = direction;
    }

    public FireMessage(RegistryFriendlyByteBuf b) {
        this.slot = b.readInt();
        this.index = b.readInt();
        this.direction = new Vector3f(b.readFloat(), b.readFloat(), b.readFloat());
    }

    public int getSlot() {
        return this.slot;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeInt(this.slot);
        b.writeInt(this.index);
        b.writeFloat(this.direction.x());
        b.writeFloat(this.direction.y());
        b.writeFloat(this.direction.z());
    }

    @Override
    public void receiveServer(ServerPlayer e) {
        Entity entity = e.getVehicle();
        if (entity instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)entity;
            vehicle.fireWeapon(this.slot, this.index, this.direction);
        }
    }
}

