/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.inventory.slots;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.slots.TooltippedSlotDescription;
import immersive_aircraft.screen.slot.IngredientSlot;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientSlotDescription
extends TooltippedSlotDescription {
    final Ingredient ingredient;
    final int maxStackSize;

    public IngredientSlotDescription(String type, int index, int x, int y, JsonObject json) {
        this(type, index, x, y, json, (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(), GsonHelper.getAsInt((JsonObject)json, (String)"maxStackSize", (int)64));
    }

    public IngredientSlotDescription(String type, int index, int x, int y, JsonObject json, Ingredient ingredient, int maxStackSize) {
        super(type, index, x, y, json);
        this.ingredient = ingredient;
        this.maxStackSize = maxStackSize;
    }

    public IngredientSlotDescription(String type, RegistryFriendlyByteBuf buffer) {
        super(type, buffer);
        this.ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        this.maxStackSize = buffer.readInt();
    }

    @Override
    public Slot getSlot(InventoryVehicleEntity vehicle, Container inventory) {
        return new IngredientSlot(this.ingredient, this.maxStackSize, inventory, this.index, this.x, this.y);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)this.ingredient);
        buffer.writeInt(this.maxStackSize);
    }
}

