/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.HeavyCrossbow;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class WarshipEntity
extends AirshipEntity {
    private final HeavyCrossbow turret;
    public final InterpolatedFloat turretYaw = new InterpolatedFloat(5.0f);
    public final InterpolatedFloat turretPitch = new InterpolatedFloat(5.0f);

    public WarshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
        this.turret = new HeavyCrossbow(this, new ItemStack((ItemLike)Items.HEAVY_CROSSBOW.get()), new WeaponMount(new Matrix4f(), false), -1, 5.0f, 0.0f);
    }

    @Override
    public Item asItem() {
        return Items.WARSHIP.get();
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("turret_yaw", -this.turretYaw.getSmooth(tickDelta));
        BBAnimationVariables.set("turret_pitch", -this.turretPitch.getSmooth(tickDelta));
        if (this.weapons.isEmpty()) {
            BBAnimationVariables.set("balloon_roll", (float)Utils.cosNoise(((float)this.tickCount + tickDelta) * 0.01f) * 0.2f + this.getRoll(tickDelta) * 0.5f);
            BBAnimationVariables.set("balloon_pitch", (float)Utils.cosNoise(77.0f + ((float)this.tickCount + tickDelta) * 0.02f) * 0.2f);
        } else {
            BBAnimationVariables.set("balloon_roll", 0.0f);
            BBAnimationVariables.set("balloon_pitch", 0.0f);
        }
        BBAnimationVariables.set("chest", (float)Math.max((double)0.0, (double)this.getSpeedVector().y));
        BBAnimationVariables.set("turret_cooldown", this.turret.getCooldown());
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 100.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WARSHIP.get();
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START_WARSHIP.get();
    }

    public Vector3f boneOffset(Vector3f position, Vector3f rotation, Vector3f origin) {
        position.sub((Vector3fc)origin);
        position = Utils.fromXYZ(rotation).transform(position);
        position.add((Vector3fc)origin);
        return position;
    }

    public Entity getTurretGunner() {
        List passengers = this.getPassengers();
        if (passengers.size() >= 2) {
            return (Entity)passengers.get(1);
        }
        return null;
    }

    public boolean isTurretGunner(Entity entity) {
        return this.getTurretGunner() == entity;
    }

    @Override
    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction positionUpdater) {
        Matrix4f transform = this.getVehicleTransform();
        if (this.isTurretGunner(passenger)) {
            Vector3f position = this.getGunnerPosition();
            float x = position.x();
            float y = position.y();
            float z = position.z();
            Vec3 attachmentPoint = passenger.getVehicleAttachmentPoint((Entity)this);
            Vector4f worldPosition = this.transformPosition(transform, x -= (float)attachmentPoint.x, y -= (float)attachmentPoint.y, z -= (float)attachmentPoint.z);
            positionUpdater.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
        } else {
            super.positionRider(passenger, positionUpdater);
        }
    }

    private Vector3f getGunnerPosition() {
        float pitch = this.turretPitch.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        float yaw = this.turretYaw.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        Vector3f position = new Vector3f(0.0f, 0.5f, 2.5f);
        this.boneOffset(position, new Vector3f(0.0f, -yaw, 0.0f), new Vector3f(0.0f, 0.5f, 2.0f));
        this.boneOffset(position, new Vector3f(pitch, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.9f));
        return position;
    }

    @Override
    public void copyEntityData(Entity entity) {
        if (this.isTurretGunner(entity)) {
            entity.setYBodyRot(this.getYRot() + this.turretYaw.getSmooth(1.0f));
            float py = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float cpy = Mth.clamp((float)py, (float)-45.0f, (float)45.0f);
            entity.yRotO += cpy - py;
            entity.setYRot(entity.getYRot() + cpy - py);
            entity.setYHeadRot(entity.getYRot());
            float pp = Mth.wrapDegrees((float)(entity.getXRot() - this.getXRot()));
            float cpp = Mth.clamp((float)pp, (float)-30.0f, (float)30.0f);
            entity.xRotO += cpp - pp;
            entity.setXRot(entity.getXRot() + cpp - pp);
        } else {
            super.copyEntityData(entity);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.turret.tick();
        Entity gunner = this.getTurretGunner();
        if (gunner != null) {
            this.turretYaw.update(Math.clamp((float)-75.0f, (float)75.0f, (float)Mth.wrapDegrees((float)(gunner.getYHeadRot() - this.getYRot()))));
            this.turretPitch.update(Math.clamp((float)-30.0f, (float)30.0f, (float)gunner.getXRot()));
        } else {
            this.turretYaw.update(0.0f);
            this.turretPitch.update(0.0f);
        }
        Vector3f gunnerPosition = this.getGunnerPosition();
        Quaternionf turretRot = Utils.fromXYZ(Math.toRadians((float)this.turretPitch.get(1.0f)), Math.toRadians((float)(-this.turretYaw.get(1.0f))), 0.0f);
        this.turret.getMount().transform().identity().translate((Vector3fc)gunnerPosition).rotate((Quaternionfc)turretRot);
    }

    @Override
    public void clientFireWeapons(Entity entity) {
        if (this.isTurretGunner(entity)) {
            this.turret.clientFire(-1);
        } else {
            super.clientFireWeapons(entity);
        }
    }

    @Override
    public void fireWeapon(int slot, int index, Vector3f direction) {
        if (slot == -1) {
            this.turret.fire(direction);
        } else {
            super.fireWeapon(slot, index, direction);
        }
    }

    @Override
    public double getZoom() {
        return 5.0f + this.enginePower.getSmooth(Main.frameTime) * 5.0f;
    }
}

