/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Axis;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class AircraftEntity
extends EngineVehicle {
    protected double lastY;
    public float inWaterLevel;
    private List<Trail> trails = Collections.emptyList();

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super((EntityType<? extends EngineVehicle>)entityType, world, canExplodeOnCrash);
    }

    public List<Trail> getTrails() {
        if (this.getVehicleData().getTrails().size() != this.trails.size()) {
            this.trails = new ArrayList<Trail>(this.getVehicleData().getTrails().size());
            for (TrailDescriptor trail : this.getVehicleData().getTrails()) {
                this.trails.add(new Trail(trail.length(), trail.gray()));
            }
        }
        return this.trails;
    }

    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return 1.0f;
    }

    private void recordTrail(Matrix4f transform, int index, TrailDescriptor trail) {
        Matrix4f t = new Matrix4f((Matrix4fc)transform);
        t.translate(trail.x(), trail.y(), trail.z());
        if ((double)trail.rotate() != 0.0) {
            t.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.engineRotation.getSmooth() * trail.rotate()));
        }
        Vector4f p0 = this.mulXVec((Matrix4fc)t, -trail.size());
        Vector4f p1 = this.mulXVec((Matrix4fc)t, trail.size());
        float trailStrength = Math.max(0.0f, Math.min(1.0f, this.getBaseTrailWidth(t, index, trail)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    private Vector4f mulXVec(Matrix4fc mat, float x) {
        return new Vector4f(Math.fma(mat.m00(), x, mat.m30()), Math.fma(mat.m01(), x, mat.m31()), Math.fma(mat.m02(), x, mat.m32()), Math.fma(mat.m03(), x, mat.m33()));
    }

    @Override
    public void tick() {
        List<TrailDescriptor> trailDescriptors;
        this.prevRoll = this.roll;
        if (this.onGround()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR) * (1.0f - this.inWaterLevel));
        }
        if (Double.isNaN(this.getDeltaMovement().x) || Double.isNaN(this.getDeltaMovement().y) || Double.isNaN(this.getDeltaMovement().z)) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (!(trailDescriptors = this.getVehicleData().getTrails()).isEmpty()) {
            Matrix4f vehicleTransform = this.getVehicleTransform();
            for (int i = 0; i < trailDescriptors.size(); ++i) {
                TrailDescriptor trail = trailDescriptors.get(i);
                this.recordTrail(vehicleTransform, i, trail);
            }
        }
        this.inWaterLevel = this.wasTouchingWater ? Math.min(1.0f, this.inWaterLevel + 0.05f) : Math.max(0.0f, this.inWaterLevel - 0.05f);
        super.tick();
    }

    protected void convertPower(Vec3 direction) {
        Vec3 velocity = this.getDeltaMovement();
        double drag = Math.abs(direction.dot(velocity.normalize()));
        this.setDeltaMovement(velocity.normalize().lerp(direction, (double)this.getProperties().get(VehicleStat.LIFT)).scale(velocity.length() * (drag * (double)this.getProperties().get(VehicleStat.FRICTION) + (1.0 - (double)this.getProperties().get(VehicleStat.FRICTION)))));
    }

    @Override
    protected float getGroundDecay() {
        float gravity = Math.min(1.0f, Math.max(0.0f, (float)this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(VehicleStat.ACCELERATION) * 0.5f);
        return (super.getGroundDecay() * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateController() {
        this.setYRot(this.getYRot() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (!this.onGround()) {
            this.setXRot(this.getXRot() + this.getProperties().get(VehicleStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.setXRot(this.getXRot() * (1.0f - this.getProperties().getAdditive(VehicleStat.STABILIZER)));
    }

    @Override
    protected void updateVelocity() {
        Vector3f direction = this.getForwardDirection();
        float diff = (float)(this.lastY - this.getY());
        if (this.lastY != 0.0 && this.getProperties().get(VehicleStat.GLIDE_FACTOR) > 0.0f && (double)diff != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(this.toVec3d(direction).scale((double)(diff * this.getProperties().get(VehicleStat.GLIDE_FACTOR) * (1.0f - Math.abs(direction.y))))));
        }
        this.lastY = (float)this.getY();
        this.convertPower(this.toVec3d(direction));
        this.applyFriction();
        if (this.onGround()) {
            this.setXRot((this.getXRot() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        } else if (!this.wasTouchingWater) {
            Vector3f effect = this.getWindEffect();
            this.setXRot(this.getXRot() + effect.x);
            this.setYRot(this.getYRot() + effect.z);
            float offsetStrength = 0.005f;
            this.setDeltaMovement(this.getDeltaMovement().add((double)(effect.x * offsetStrength), 0.0, (double)(effect.z * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(VehicleStat.WIND);
        float thundering = this.level().getRainLevel(0.0f);
        float raining = this.level().getThunderLevel(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.getDeltaMovement().length() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.tickCount / 20.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.tickCount / 21.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

