/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SpeedIndicator
implements Indicator {
    public static final SpeedIndicator INSTANCE = new SpeedIndicator();
    private Vec3 lastSpeed = new Vec3(0.0, 0.0, 0.0);
    private Vec3 iSpeed = new Vec3(0.0, 0.0, 0.0);
    private Vec3 iSpeedRt = new Vec3(0.0, 0.0, 0.0);
    private Vec3 mSpeed = new Vec3(0.0, 0.0, 0.0);
    private Vec3 dir = new Vec3(0.0, 0.0, 0.0);
    private static final int widthHalf = 100;
    private static final int bHeightHalf = 35;

    @Override
    public void update(Minecraft client, EngineVehicle aircraft) {
        Vec3 speed = aircraft.getSpeedVector().scale(20.0);
        this.dir = Vec3.directionFromRotation((Vec2)aircraft.getRotationVector());
        if (!speed.equals((Object)this.lastSpeed)) {
            this.iSpeed = speed.add(this.lastSpeed.reverse());
            this.iSpeedRt = this.iSpeed.scale(-0.03333333507180214);
            this.lastSpeed = speed;
        }
        if (this.iSpeed.add(this.iSpeedRt).dot(this.iSpeed) > 0.0) {
            this.iSpeed = this.iSpeed.add(this.iSpeedRt);
        } else {
            this.iSpeed = new Vec3(0.0, 0.0, 0.0);
            this.iSpeedRt = new Vec3(0.0, 0.0, 0.0);
        }
        this.mSpeed = this.lastSpeed.add(this.iSpeed.reverse());
    }

    @Override
    public void drawDashboard(GuiGraphics context, Minecraft client, int baseX, int baseY, EngineVehicle aircraft, int color) {
        StringDrawer.drawString1(context, client, String.format("AS %2.1f", this.lastSpeed.dot(this.dir)), baseX - 100, baseY, color, true);
    }

    @Override
    public void drawHUD(GuiGraphics context, Minecraft client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        for (int i = -35; i < 35; i += 5) {
            if (!this.edgeCheck(edge, 2, baseX - 3, baseY + i * width / 100)) continue;
            OverlayRenderer.renderLine(context, baseX - 3, baseY + i * width / 100 - 1, baseX - 3, baseY + (i + 5) * width / 100 + 1, color);
        }
        if (this.edgeCheck(edge, 5, baseX, baseY)) {
            Objects.requireNonNull(client.font);
            StringDrawer.drawString6(context, client, "AS", baseX - 10, baseY - 9, color, false);
            StringDrawer.drawString6(context, client, String.format("[%2.1f}-", this.lastSpeed.dot(this.dir)), baseX, baseY, color, false);
        }
        int iz = Double.valueOf(this.mSpeed.dot(this.dir) * 10.0).intValue();
        int nearest1_10 = Math.floorDiv(iz, 10);
        PrimitiveIterator.OfInt it = IntStream.range(nearest1_10 - 5, nearest1_10 + 6).iterator();
        while (it.hasNext()) {
            String vp;
            int v = (Integer)it.next();
            Object object = v % 10 == 0 ? (v == nearest1_10 ? "\u2500" : "\u00b7" + String.valueOf(v / 10) + "\u00b7") : (vp = v % 5 == 0 ? "\u2500" : "-");
            int yy = baseY + (iz - v * 10) * width / 100;
            if (!this.edgeCheck(edge, 5, baseX, yy)) continue;
            StringDrawer.drawString6(context, client, vp, baseX, yy, color, false);
        }
    }

    @Override
    public void drawDials(GuiGraphics context, Minecraft client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        float angle;
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        Vec3 scale0 = new Vec3(0.0, (double)(25 * scale), 0.0);
        Vec3 scale1 = new Vec3(0.0, (double)(22 * scale), 0.0);
        Vec3 scale2 = new Vec3(0.0, (double)(20 * scale), 0.0);
        Vec3 scale3 = new Vec3(0.0, (double)(16 * scale), 0.0);
        for (int i = 0; i < 60; ++i) {
            angle = -((float)Math.toRadians(6.0f * (float)i));
            Vec3 sa = scale0.zRot(angle);
            Vec3 sb = i % 10 == 0 ? scale2.zRot(angle) : scale1.zRot(angle);
            OverlayRenderer.renderLine(context, baseX + (int)sa.x, baseY + (int)sa.y, baseX + (int)sb.x, baseY + (int)sb.y, Colors.colorFG);
            if (i % 10 != 0) continue;
            Vec3 sc = scale3.zRot(angle);
            StringDrawer.drawString5(context, client, String.valueOf(i / 10), baseX + (int)sc.x + 2, baseY + (int)sc.y - 1, Colors.colorFG, false);
        }
        int iz = Double.valueOf(this.mSpeed.dot(this.dir) * 10.0).intValue();
        angle = -((float)Math.toRadians((float)iz * 0.6f));
        Vec3 h1 = scale1.zRot(angle);
        OverlayRenderer.renderLine(context, baseX, baseY, baseX + (int)h1.x, baseY + (int)h1.y, Colors.colorHD1, false, true);
        OverlayRenderer.drawDialOutline(context, baseX, baseY, scale);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "AS", baseX + 20 * scale + 1, baseY + 25 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 13;
            int y = baseY + 26;
            context.fill(x, y - 4, x + 1, y, Colors.colorFG);
            context.fill(x + 1, y - 5, x + 2, y - 4, Colors.colorFG);
            context.fill(x + 2, y - 4, x + 3, y, Colors.colorFG);
            context.fill(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            x = baseX + 16;
            y = baseY + 26;
            context.fill(x + 1, y - 5, x + 3, y - 4, Colors.colorFG);
            context.fill(x, y - 4, x + 1, y - 3, Colors.colorFG);
            context.fill(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            context.fill(x + 2, y - 3, x + 3, y - 1, Colors.colorFG);
            context.fill(x, y - 1, x + 2, y, Colors.colorFG);
        }
        context.fill(baseX - 3 * scale, baseY - 3 * scale, baseX + 3 * scale + 1, baseY + 3 * scale + 1, Colors.colorFG);
        context.fill(baseX - 2 * scale, baseY - 2 * scale, baseX + 2 * scale + 1, baseY + 2 * scale + 1, iz >= 0 && iz < 600 ? Colors.colorLt0 : Colors.colorLt1);
    }
}

